<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyDefinition StructType
 * @subpackage Structs
 */
class PropertyDefinition extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The DataType
     * Meta informations extracted from the WSDL
     * - documentation: Deprecated. Please use ValueType.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataType;
    /**
     * The ValueType
     * Meta informations extracted from the WSDL
     * - documentation: Actual data type of the value that will be stored in this property | Reserved for future use.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValueType;
    /**
     * The PropertyType
     * Meta informations extracted from the WSDL
     * - documentation: ExactTarget data type of the property
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PropertyType;
    /**
     * The IsCreatable
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the property can be created. If true, then this property value can be set in a create call. | Reserved for future use.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsCreatable;
    /**
     * The IsUpdatable
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the property can be updated. If true, then this property value can be set in an update call.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsUpdatable;
    /**
     * The IsRetrievable
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the object can be retrieved via the retrieve call.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsRetrievable;
    /**
     * The IsQueryable
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the object can be queried via the query call. | Reserved for future use.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsQueryable;
    /**
     * The IsFilterable
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the property is filterable. If true, then this property can be specified in a SimpleFilterPart in a retrieve call. | Reserved for future use.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsFilterable;
    /**
     * The IsPartnerProperty
     * Meta informations extracted from the WSDL
     * - documentation: Indicates if the property is specific to a partner. | Reserved for future use.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsPartnerProperty;
    /**
     * The IsAccountProperty
     * Meta informations extracted from the WSDL
     * - documentation: Indicates if the property is specific to the Account. | Reserved for future use.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsAccountProperty;
    /**
     * The PartnerMap
     * Meta informations extracted from the WSDL
     * - documentation: Deprecated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerMap;
    /**
     * The AttributeMaps
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AttributeMap[]
     */
    public $AttributeMaps;
    /**
     * The Markups
     * Meta informations extracted from the WSDL
     * - documentation: Deprecated.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $Markups;
    /**
     * The Precision
     * Meta informations extracted from the WSDL
     * - documentation: Reserved for future use.
     * - minOccurs: 0
     * @var int
     */
    public $Precision;
    /**
     * The Scale
     * Meta informations extracted from the WSDL
     * - documentation: Reserved for future use.
     * - minOccurs: 0
     * @var int
     */
    public $Scale;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - documentation: Text label that is displayed next to the field in the user interface.
     * - minOccurs: 0
     * @var string
     */
    public $Label;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DefaultValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DefaultValue;
    /**
     * The MinLength
     * Meta informations extracted from the WSDL
     * - documentation: Minimum length of the data.
     * - minOccurs: 0
     * @var int
     */
    public $MinLength;
    /**
     * The MaxLength
     * Meta informations extracted from the WSDL
     * - documentation: Maximum length of the data.
     * - minOccurs: 0
     * @var int
     */
    public $MaxLength;
    /**
     * The MinValue
     * Meta informations extracted from the WSDL
     * - documentation: Minimum value that this property can be set to.
     * - minOccurs: 0
     * @var string
     */
    public $MinValue;
    /**
     * The MaxValue
     * Meta informations extracted from the WSDL
     * - documentation: Maximum value that this property can be set to.
     * - minOccurs: 0
     * @var string
     */
    public $MaxValue;
    /**
     * The IsRequired
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the property must have a value specified.
     * - minOccurs: 0
     * @var bool
     */
    public $IsRequired;
    /**
     * The IsViewable
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the property is viewable to the end-user in the profile center.
     * - minOccurs: 0
     * @var bool
     */
    public $IsViewable;
    /**
     * The IsEditable
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the property is editable by the end-user in the profile center.
     * - minOccurs: 0
     * @var bool
     */
    public $IsEditable;
    /**
     * The IsNillable
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the property can contain a null value. | Reserved for future use.
     * - minOccurs: 0
     * @var bool
     */
    public $IsNillable;
    /**
     * The IsRestrictedPicklist
     * Meta informations extracted from the WSDL
     * - documentation: Indicates if the property has a restricted list of valid values.
     * - minOccurs: 0
     * @var bool
     */
    public $IsRestrictedPicklist;
    /**
     * The PicklistItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PicklistItems
     */
    public $PicklistItems;
    /**
     * The IsSendTime
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the property is a send time attribute.
     * - minOccurs: 0
     * @var bool
     */
    public $IsSendTime;
    /**
     * The DisplayOrder
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the placement of this property within the list of properties.
     * - minOccurs: 0
     * @var int
     */
    public $DisplayOrder;
    /**
     * The References
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\References
     */
    public $References;
    /**
     * The RelationshipName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the relationship (e.g. One-to-One, One-to-Many). | Reserved for future use.
     * - minOccurs: 0
     * @var string
     */
    public $RelationshipName;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Reserved for future use.
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The IsContextSpecific
     * Meta informations extracted from the WSDL
     * - documentation: Reserved for future use.
     * - minOccurs: 0
     * @var bool
     */
    public $IsContextSpecific;
    /**
     * Constructor method for PropertyDefinition
     * @uses PropertyDefinition::setName()
     * @uses PropertyDefinition::setDataType()
     * @uses PropertyDefinition::setValueType()
     * @uses PropertyDefinition::setPropertyType()
     * @uses PropertyDefinition::setIsCreatable()
     * @uses PropertyDefinition::setIsUpdatable()
     * @uses PropertyDefinition::setIsRetrievable()
     * @uses PropertyDefinition::setIsQueryable()
     * @uses PropertyDefinition::setIsFilterable()
     * @uses PropertyDefinition::setIsPartnerProperty()
     * @uses PropertyDefinition::setIsAccountProperty()
     * @uses PropertyDefinition::setPartnerMap()
     * @uses PropertyDefinition::setAttributeMaps()
     * @uses PropertyDefinition::setMarkups()
     * @uses PropertyDefinition::setPrecision()
     * @uses PropertyDefinition::setScale()
     * @uses PropertyDefinition::setLabel()
     * @uses PropertyDefinition::setDescription()
     * @uses PropertyDefinition::setDefaultValue()
     * @uses PropertyDefinition::setMinLength()
     * @uses PropertyDefinition::setMaxLength()
     * @uses PropertyDefinition::setMinValue()
     * @uses PropertyDefinition::setMaxValue()
     * @uses PropertyDefinition::setIsRequired()
     * @uses PropertyDefinition::setIsViewable()
     * @uses PropertyDefinition::setIsEditable()
     * @uses PropertyDefinition::setIsNillable()
     * @uses PropertyDefinition::setIsRestrictedPicklist()
     * @uses PropertyDefinition::setPicklistItems()
     * @uses PropertyDefinition::setIsSendTime()
     * @uses PropertyDefinition::setDisplayOrder()
     * @uses PropertyDefinition::setReferences()
     * @uses PropertyDefinition::setRelationshipName()
     * @uses PropertyDefinition::setStatus()
     * @uses PropertyDefinition::setIsContextSpecific()
     * @param string $name
     * @param string $dataType
     * @param string $valueType
     * @param string $propertyType
     * @param bool $isCreatable
     * @param bool $isUpdatable
     * @param bool $isRetrievable
     * @param bool $isQueryable
     * @param bool $isFilterable
     * @param bool $isPartnerProperty
     * @param bool $isAccountProperty
     * @param string $partnerMap
     * @param \App\Library\ExactTarget\StructType\AttributeMap[] $attributeMaps
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $markups
     * @param int $precision
     * @param int $scale
     * @param string $label
     * @param string $description
     * @param string $defaultValue
     * @param int $minLength
     * @param int $maxLength
     * @param string $minValue
     * @param string $maxValue
     * @param bool $isRequired
     * @param bool $isViewable
     * @param bool $isEditable
     * @param bool $isNillable
     * @param bool $isRestrictedPicklist
     * @param \App\Library\ExactTarget\StructType\PicklistItems $picklistItems
     * @param bool $isSendTime
     * @param int $displayOrder
     * @param \App\Library\ExactTarget\StructType\References $references
     * @param string $relationshipName
     * @param string $status
     * @param bool $isContextSpecific
     */
    public function __construct($name = null, $dataType = null, $valueType = null, $propertyType = null, $isCreatable = null, $isUpdatable = null, $isRetrievable = null, $isQueryable = null, $isFilterable = null, $isPartnerProperty = null, $isAccountProperty = null, $partnerMap = null, array $attributeMaps = array(), array $markups = array(), $precision = null, $scale = null, $label = null, $description = null, $defaultValue = null, $minLength = null, $maxLength = null, $minValue = null, $maxValue = null, $isRequired = null, $isViewable = null, $isEditable = null, $isNillable = null, $isRestrictedPicklist = null, \App\Library\ExactTarget\StructType\PicklistItems $picklistItems = null, $isSendTime = null, $displayOrder = null, \App\Library\ExactTarget\StructType\References $references = null, $relationshipName = null, $status = null, $isContextSpecific = null)
    {
        $this
            ->setName($name)
            ->setDataType($dataType)
            ->setValueType($valueType)
            ->setPropertyType($propertyType)
            ->setIsCreatable($isCreatable)
            ->setIsUpdatable($isUpdatable)
            ->setIsRetrievable($isRetrievable)
            ->setIsQueryable($isQueryable)
            ->setIsFilterable($isFilterable)
            ->setIsPartnerProperty($isPartnerProperty)
            ->setIsAccountProperty($isAccountProperty)
            ->setPartnerMap($partnerMap)
            ->setAttributeMaps($attributeMaps)
            ->setMarkups($markups)
            ->setPrecision($precision)
            ->setScale($scale)
            ->setLabel($label)
            ->setDescription($description)
            ->setDefaultValue($defaultValue)
            ->setMinLength($minLength)
            ->setMaxLength($maxLength)
            ->setMinValue($minValue)
            ->setMaxValue($maxValue)
            ->setIsRequired($isRequired)
            ->setIsViewable($isViewable)
            ->setIsEditable($isEditable)
            ->setIsNillable($isNillable)
            ->setIsRestrictedPicklist($isRestrictedPicklist)
            ->setPicklistItems($picklistItems)
            ->setIsSendTime($isSendTime)
            ->setDisplayOrder($displayOrder)
            ->setReferences($references)
            ->setRelationshipName($relationshipName)
            ->setStatus($status)
            ->setIsContextSpecific($isContextSpecific);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get DataType value
     * @return string|null
     */
    public function getDataType()
    {
        return $this->DataType;
    }
    /**
     * Set DataType value
     * @param string $dataType
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setDataType($dataType = null)
    {
        // validation for constraint: string
        if (!is_null($dataType) && !is_string($dataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataType)), __LINE__);
        }
        $this->DataType = $dataType;
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @uses \App\Library\ExactTarget\EnumType\SoapType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SoapType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueType
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SoapType::valueIsValid($valueType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $valueType, implode(', ', \App\Library\ExactTarget\EnumType\SoapType::getValidValues())), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
    /**
     * Get PropertyType value
     * @return string|null
     */
    public function getPropertyType()
    {
        return $this->PropertyType;
    }
    /**
     * Set PropertyType value
     * @uses \App\Library\ExactTarget\EnumType\PropertyType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\PropertyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyType
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setPropertyType($propertyType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\PropertyType::valueIsValid($propertyType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $propertyType, implode(', ', \App\Library\ExactTarget\EnumType\PropertyType::getValidValues())), __LINE__);
        }
        $this->PropertyType = $propertyType;
        return $this;
    }
    /**
     * Get IsCreatable value
     * @return bool|null
     */
    public function getIsCreatable()
    {
        return $this->IsCreatable;
    }
    /**
     * Set IsCreatable value
     * @param bool $isCreatable
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsCreatable($isCreatable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCreatable) && !is_bool($isCreatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCreatable)), __LINE__);
        }
        $this->IsCreatable = $isCreatable;
        return $this;
    }
    /**
     * Get IsUpdatable value
     * @return bool|null
     */
    public function getIsUpdatable()
    {
        return $this->IsUpdatable;
    }
    /**
     * Set IsUpdatable value
     * @param bool $isUpdatable
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsUpdatable($isUpdatable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdatable) && !is_bool($isUpdatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpdatable)), __LINE__);
        }
        $this->IsUpdatable = $isUpdatable;
        return $this;
    }
    /**
     * Get IsRetrievable value
     * @return bool|null
     */
    public function getIsRetrievable()
    {
        return $this->IsRetrievable;
    }
    /**
     * Set IsRetrievable value
     * @param bool $isRetrievable
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsRetrievable($isRetrievable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRetrievable) && !is_bool($isRetrievable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRetrievable)), __LINE__);
        }
        $this->IsRetrievable = $isRetrievable;
        return $this;
    }
    /**
     * Get IsQueryable value
     * @return bool|null
     */
    public function getIsQueryable()
    {
        return $this->IsQueryable;
    }
    /**
     * Set IsQueryable value
     * @param bool $isQueryable
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsQueryable($isQueryable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isQueryable) && !is_bool($isQueryable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isQueryable)), __LINE__);
        }
        $this->IsQueryable = $isQueryable;
        return $this;
    }
    /**
     * Get IsFilterable value
     * @return bool|null
     */
    public function getIsFilterable()
    {
        return $this->IsFilterable;
    }
    /**
     * Set IsFilterable value
     * @param bool $isFilterable
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsFilterable($isFilterable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFilterable) && !is_bool($isFilterable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isFilterable)), __LINE__);
        }
        $this->IsFilterable = $isFilterable;
        return $this;
    }
    /**
     * Get IsPartnerProperty value
     * @return bool|null
     */
    public function getIsPartnerProperty()
    {
        return $this->IsPartnerProperty;
    }
    /**
     * Set IsPartnerProperty value
     * @param bool $isPartnerProperty
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsPartnerProperty($isPartnerProperty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartnerProperty) && !is_bool($isPartnerProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPartnerProperty)), __LINE__);
        }
        $this->IsPartnerProperty = $isPartnerProperty;
        return $this;
    }
    /**
     * Get IsAccountProperty value
     * @return bool|null
     */
    public function getIsAccountProperty()
    {
        return $this->IsAccountProperty;
    }
    /**
     * Set IsAccountProperty value
     * @param bool $isAccountProperty
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsAccountProperty($isAccountProperty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccountProperty) && !is_bool($isAccountProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAccountProperty)), __LINE__);
        }
        $this->IsAccountProperty = $isAccountProperty;
        return $this;
    }
    /**
     * Get PartnerMap value
     * @return string|null
     */
    public function getPartnerMap()
    {
        return $this->PartnerMap;
    }
    /**
     * Set PartnerMap value
     * @param string $partnerMap
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setPartnerMap($partnerMap = null)
    {
        // validation for constraint: string
        if (!is_null($partnerMap) && !is_string($partnerMap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerMap)), __LINE__);
        }
        $this->PartnerMap = $partnerMap;
        return $this;
    }
    /**
     * Get AttributeMaps value
     * @return \App\Library\ExactTarget\StructType\AttributeMap[]|null
     */
    public function getAttributeMaps()
    {
        return $this->AttributeMaps;
    }
    /**
     * Set AttributeMaps value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AttributeMap[] $attributeMaps
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setAttributeMaps(array $attributeMaps = array())
    {
        foreach ($attributeMaps as $propertyDefinitionAttributeMapsItem) {
            // validation for constraint: itemType
            if (!$propertyDefinitionAttributeMapsItem instanceof \App\Library\ExactTarget\StructType\AttributeMap) {
                throw new \InvalidArgumentException(sprintf('The AttributeMaps property can only contain items of \App\Library\ExactTarget\StructType\AttributeMap, "%s" given', is_object($propertyDefinitionAttributeMapsItem) ? get_class($propertyDefinitionAttributeMapsItem) : gettype($propertyDefinitionAttributeMapsItem)), __LINE__);
            }
        }
        $this->AttributeMaps = $attributeMaps;
        return $this;
    }
    /**
     * Add item to AttributeMaps value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AttributeMap $item
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function addToAttributeMaps(\App\Library\ExactTarget\StructType\AttributeMap $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AttributeMap) {
            throw new \InvalidArgumentException(sprintf('The AttributeMaps property can only contain items of \App\Library\ExactTarget\StructType\AttributeMap, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AttributeMaps[] = $item;
        return $this;
    }
    /**
     * Get Markups value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getMarkups()
    {
        return $this->Markups;
    }
    /**
     * Set Markups value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $markups
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setMarkups(array $markups = array())
    {
        foreach ($markups as $propertyDefinitionMarkupsItem) {
            // validation for constraint: itemType
            if (!$propertyDefinitionMarkupsItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The Markups property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($propertyDefinitionMarkupsItem) ? get_class($propertyDefinitionMarkupsItem) : gettype($propertyDefinitionMarkupsItem)), __LINE__);
            }
        }
        $this->Markups = $markups;
        return $this;
    }
    /**
     * Add item to Markups value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function addToMarkups(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The Markups property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Markups[] = $item;
        return $this;
    }
    /**
     * Get Precision value
     * @return int|null
     */
    public function getPrecision()
    {
        return $this->Precision;
    }
    /**
     * Set Precision value
     * @param int $precision
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setPrecision($precision = null)
    {
        // validation for constraint: int
        if (!is_null($precision) && !is_numeric($precision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($precision)), __LINE__);
        }
        $this->Precision = $precision;
        return $this;
    }
    /**
     * Get Scale value
     * @return int|null
     */
    public function getScale()
    {
        return $this->Scale;
    }
    /**
     * Set Scale value
     * @param int $scale
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setScale($scale = null)
    {
        // validation for constraint: int
        if (!is_null($scale) && !is_numeric($scale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scale)), __LINE__);
        }
        $this->Scale = $scale;
        return $this;
    }
    /**
     * Get Label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param string $label
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DefaultValue value
     * @return string|null
     */
    public function getDefaultValue()
    {
        return $this->DefaultValue;
    }
    /**
     * Set DefaultValue value
     * @param string $defaultValue
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: string
        if (!is_null($defaultValue) && !is_string($defaultValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultValue)), __LINE__);
        }
        $this->DefaultValue = $defaultValue;
        return $this;
    }
    /**
     * Get MinLength value
     * @return int|null
     */
    public function getMinLength()
    {
        return $this->MinLength;
    }
    /**
     * Set MinLength value
     * @param int $minLength
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setMinLength($minLength = null)
    {
        // validation for constraint: int
        if (!is_null($minLength) && !is_numeric($minLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minLength)), __LINE__);
        }
        $this->MinLength = $minLength;
        return $this;
    }
    /**
     * Get MaxLength value
     * @return int|null
     */
    public function getMaxLength()
    {
        return $this->MaxLength;
    }
    /**
     * Set MaxLength value
     * @param int $maxLength
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setMaxLength($maxLength = null)
    {
        // validation for constraint: int
        if (!is_null($maxLength) && !is_numeric($maxLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxLength)), __LINE__);
        }
        $this->MaxLength = $maxLength;
        return $this;
    }
    /**
     * Get MinValue value
     * @return string|null
     */
    public function getMinValue()
    {
        return $this->MinValue;
    }
    /**
     * Set MinValue value
     * @param string $minValue
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setMinValue($minValue = null)
    {
        // validation for constraint: string
        if (!is_null($minValue) && !is_string($minValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minValue)), __LINE__);
        }
        $this->MinValue = $minValue;
        return $this;
    }
    /**
     * Get MaxValue value
     * @return string|null
     */
    public function getMaxValue()
    {
        return $this->MaxValue;
    }
    /**
     * Set MaxValue value
     * @param string $maxValue
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setMaxValue($maxValue = null)
    {
        // validation for constraint: string
        if (!is_null($maxValue) && !is_string($maxValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxValue)), __LINE__);
        }
        $this->MaxValue = $maxValue;
        return $this;
    }
    /**
     * Get IsRequired value
     * @return bool|null
     */
    public function getIsRequired()
    {
        return $this->IsRequired;
    }
    /**
     * Set IsRequired value
     * @param bool $isRequired
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsRequired($isRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRequired)), __LINE__);
        }
        $this->IsRequired = $isRequired;
        return $this;
    }
    /**
     * Get IsViewable value
     * @return bool|null
     */
    public function getIsViewable()
    {
        return $this->IsViewable;
    }
    /**
     * Set IsViewable value
     * @param bool $isViewable
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsViewable($isViewable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isViewable) && !is_bool($isViewable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isViewable)), __LINE__);
        }
        $this->IsViewable = $isViewable;
        return $this;
    }
    /**
     * Get IsEditable value
     * @return bool|null
     */
    public function getIsEditable()
    {
        return $this->IsEditable;
    }
    /**
     * Set IsEditable value
     * @param bool $isEditable
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsEditable($isEditable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEditable) && !is_bool($isEditable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEditable)), __LINE__);
        }
        $this->IsEditable = $isEditable;
        return $this;
    }
    /**
     * Get IsNillable value
     * @return bool|null
     */
    public function getIsNillable()
    {
        return $this->IsNillable;
    }
    /**
     * Set IsNillable value
     * @param bool $isNillable
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsNillable($isNillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNillable) && !is_bool($isNillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNillable)), __LINE__);
        }
        $this->IsNillable = $isNillable;
        return $this;
    }
    /**
     * Get IsRestrictedPicklist value
     * @return bool|null
     */
    public function getIsRestrictedPicklist()
    {
        return $this->IsRestrictedPicklist;
    }
    /**
     * Set IsRestrictedPicklist value
     * @param bool $isRestrictedPicklist
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsRestrictedPicklist($isRestrictedPicklist = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRestrictedPicklist) && !is_bool($isRestrictedPicklist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRestrictedPicklist)), __LINE__);
        }
        $this->IsRestrictedPicklist = $isRestrictedPicklist;
        return $this;
    }
    /**
     * Get PicklistItems value
     * @return \App\Library\ExactTarget\StructType\PicklistItems|null
     */
    public function getPicklistItems()
    {
        return $this->PicklistItems;
    }
    /**
     * Set PicklistItems value
     * @param \App\Library\ExactTarget\StructType\PicklistItems $picklistItems
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setPicklistItems(\App\Library\ExactTarget\StructType\PicklistItems $picklistItems = null)
    {
        $this->PicklistItems = $picklistItems;
        return $this;
    }
    /**
     * Get IsSendTime value
     * @return bool|null
     */
    public function getIsSendTime()
    {
        return $this->IsSendTime;
    }
    /**
     * Set IsSendTime value
     * @param bool $isSendTime
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsSendTime($isSendTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSendTime) && !is_bool($isSendTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSendTime)), __LINE__);
        }
        $this->IsSendTime = $isSendTime;
        return $this;
    }
    /**
     * Get DisplayOrder value
     * @return int|null
     */
    public function getDisplayOrder()
    {
        return $this->DisplayOrder;
    }
    /**
     * Set DisplayOrder value
     * @param int $displayOrder
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setDisplayOrder($displayOrder = null)
    {
        // validation for constraint: int
        if (!is_null($displayOrder) && !is_numeric($displayOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($displayOrder)), __LINE__);
        }
        $this->DisplayOrder = $displayOrder;
        return $this;
    }
    /**
     * Get References value
     * @return \App\Library\ExactTarget\StructType\References|null
     */
    public function getReferences()
    {
        return $this->References;
    }
    /**
     * Set References value
     * @param \App\Library\ExactTarget\StructType\References $references
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setReferences(\App\Library\ExactTarget\StructType\References $references = null)
    {
        $this->References = $references;
        return $this;
    }
    /**
     * Get RelationshipName value
     * @return string|null
     */
    public function getRelationshipName()
    {
        return $this->RelationshipName;
    }
    /**
     * Set RelationshipName value
     * @param string $relationshipName
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setRelationshipName($relationshipName = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipName) && !is_string($relationshipName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relationshipName)), __LINE__);
        }
        $this->RelationshipName = $relationshipName;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get IsContextSpecific value
     * @return bool|null
     */
    public function getIsContextSpecific()
    {
        return $this->IsContextSpecific;
    }
    /**
     * Set IsContextSpecific value
     * @param bool $isContextSpecific
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public function setIsContextSpecific($isContextSpecific = null)
    {
        // validation for constraint: boolean
        if (!is_null($isContextSpecific) && !is_bool($isContextSpecific)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isContextSpecific)), __LINE__);
        }
        $this->IsContextSpecific = $isContextSpecific;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
