<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProgramManifestTemplate StructType
 * @subpackage Structs
 */
class ProgramManifestTemplate extends APIObject
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The OperationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationType;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Content;
    /**
     * Constructor method for ProgramManifestTemplate
     * @uses ProgramManifestTemplate::setType()
     * @uses ProgramManifestTemplate::setOperationType()
     * @uses ProgramManifestTemplate::setContent()
     * @param string $type
     * @param string $operationType
     * @param string $content
     */
    public function __construct($type = null, $operationType = null, $content = null)
    {
        $this
            ->setType($type)
            ->setOperationType($operationType)
            ->setContent($content);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \App\Library\ExactTarget\StructType\ProgramManifestTemplate
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get OperationType value
     * @return string|null
     */
    public function getOperationType()
    {
        return $this->OperationType;
    }
    /**
     * Set OperationType value
     * @param string $operationType
     * @return \App\Library\ExactTarget\StructType\ProgramManifestTemplate
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: string
        if (!is_null($operationType) && !is_string($operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationType)), __LINE__);
        }
        $this->OperationType = $operationType;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \App\Library\ExactTarget\StructType\ProgramManifestTemplate
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ProgramManifestTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
