<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlatformApplication StructType
 * @subpackage Structs
 */
class PlatformApplication extends APIObject
{
    /**
     * The Package
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\PlatformApplicationPackage
     */
    public $Package;
    /**
     * The Packages
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\PlatformApplicationPackage[]
     */
    public $Packages;
    /**
     * The ResourceSpecification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ResourceSpecification
     */
    public $ResourceSpecification;
    /**
     * The DeveloperVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeveloperVersion;
    /**
     * Constructor method for PlatformApplication
     * @uses PlatformApplication::setPackage()
     * @uses PlatformApplication::setPackages()
     * @uses PlatformApplication::setResourceSpecification()
     * @uses PlatformApplication::setDeveloperVersion()
     * @param \App\Library\ExactTarget\StructType\PlatformApplicationPackage $package
     * @param \App\Library\ExactTarget\StructType\PlatformApplicationPackage[] $packages
     * @param \App\Library\ExactTarget\StructType\ResourceSpecification $resourceSpecification
     * @param string $developerVersion
     */
    public function __construct(\App\Library\ExactTarget\StructType\PlatformApplicationPackage $package = null, array $packages = array(), \App\Library\ExactTarget\StructType\ResourceSpecification $resourceSpecification = null, $developerVersion = null)
    {
        $this
            ->setPackage($package)
            ->setPackages($packages)
            ->setResourceSpecification($resourceSpecification)
            ->setDeveloperVersion($developerVersion);
    }
    /**
     * Get Package value
     * @return \App\Library\ExactTarget\StructType\PlatformApplicationPackage
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * Set Package value
     * @param \App\Library\ExactTarget\StructType\PlatformApplicationPackage $package
     * @return \App\Library\ExactTarget\StructType\PlatformApplication
     */
    public function setPackage(\App\Library\ExactTarget\StructType\PlatformApplicationPackage $package = null)
    {
        $this->Package = $package;
        return $this;
    }
    /**
     * Get Packages value
     * @return \App\Library\ExactTarget\StructType\PlatformApplicationPackage[]
     */
    public function getPackages()
    {
        return $this->Packages;
    }
    /**
     * Set Packages value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PlatformApplicationPackage[] $packages
     * @return \App\Library\ExactTarget\StructType\PlatformApplication
     */
    public function setPackages(array $packages = array())
    {
        foreach ($packages as $platformApplicationPackagesItem) {
            // validation for constraint: itemType
            if (!$platformApplicationPackagesItem instanceof \App\Library\ExactTarget\StructType\PlatformApplicationPackage) {
                throw new \InvalidArgumentException(sprintf('The Packages property can only contain items of \App\Library\ExactTarget\StructType\PlatformApplicationPackage, "%s" given', is_object($platformApplicationPackagesItem) ? get_class($platformApplicationPackagesItem) : gettype($platformApplicationPackagesItem)), __LINE__);
            }
        }
        $this->Packages = $packages;
        return $this;
    }
    /**
     * Add item to Packages value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PlatformApplicationPackage $item
     * @return \App\Library\ExactTarget\StructType\PlatformApplication
     */
    public function addToPackages(\App\Library\ExactTarget\StructType\PlatformApplicationPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\PlatformApplicationPackage) {
            throw new \InvalidArgumentException(sprintf('The Packages property can only contain items of \App\Library\ExactTarget\StructType\PlatformApplicationPackage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Packages[] = $item;
        return $this;
    }
    /**
     * Get ResourceSpecification value
     * @return \App\Library\ExactTarget\StructType\ResourceSpecification|null
     */
    public function getResourceSpecification()
    {
        return $this->ResourceSpecification;
    }
    /**
     * Set ResourceSpecification value
     * @param \App\Library\ExactTarget\StructType\ResourceSpecification $resourceSpecification
     * @return \App\Library\ExactTarget\StructType\PlatformApplication
     */
    public function setResourceSpecification(\App\Library\ExactTarget\StructType\ResourceSpecification $resourceSpecification = null)
    {
        $this->ResourceSpecification = $resourceSpecification;
        return $this;
    }
    /**
     * Get DeveloperVersion value
     * @return string|null
     */
    public function getDeveloperVersion()
    {
        return $this->DeveloperVersion;
    }
    /**
     * Set DeveloperVersion value
     * @param string $developerVersion
     * @return \App\Library\ExactTarget\StructType\PlatformApplication
     */
    public function setDeveloperVersion($developerVersion = null)
    {
        // validation for constraint: string
        if (!is_null($developerVersion) && !is_string($developerVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($developerVersion)), __LINE__);
        }
        $this->DeveloperVersion = $developerVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\PlatformApplication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
