<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PicklistItems StructType
 * Meta informations extracted from the WSDL
 * - documentation: List of valid values.
 * @subpackage Structs
 */
class PicklistItems extends AbstractStructBase
{
    /**
     * The PicklistItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PicklistItem[]
     */
    public $PicklistItem;
    /**
     * Constructor method for PicklistItems
     * @uses PicklistItems::setPicklistItem()
     * @param \App\Library\ExactTarget\StructType\PicklistItem[] $picklistItem
     */
    public function __construct(array $picklistItem = array())
    {
        $this
            ->setPicklistItem($picklistItem);
    }
    /**
     * Get PicklistItem value
     * @return \App\Library\ExactTarget\StructType\PicklistItem[]|null
     */
    public function getPicklistItem()
    {
        return $this->PicklistItem;
    }
    /**
     * Set PicklistItem value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PicklistItem[] $picklistItem
     * @return \App\Library\ExactTarget\StructType\PicklistItems
     */
    public function setPicklistItem(array $picklistItem = array())
    {
        foreach ($picklistItem as $picklistItemsPicklistItemItem) {
            // validation for constraint: itemType
            if (!$picklistItemsPicklistItemItem instanceof \App\Library\ExactTarget\StructType\PicklistItem) {
                throw new \InvalidArgumentException(sprintf('The PicklistItem property can only contain items of \App\Library\ExactTarget\StructType\PicklistItem, "%s" given', is_object($picklistItemsPicklistItemItem) ? get_class($picklistItemsPicklistItemItem) : gettype($picklistItemsPicklistItemItem)), __LINE__);
            }
        }
        $this->PicklistItem = $picklistItem;
        return $this;
    }
    /**
     * Add item to PicklistItem value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PicklistItem $item
     * @return \App\Library\ExactTarget\StructType\PicklistItems
     */
    public function addToPicklistItem(\App\Library\ExactTarget\StructType\PicklistItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\PicklistItem) {
            throw new \InvalidArgumentException(sprintf('The PicklistItem property can only contain items of \App\Library\ExactTarget\StructType\PicklistItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PicklistItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\PicklistItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
