<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PermissionSets StructType
 * @subpackage Structs
 */
class PermissionSets extends AbstractStructBase
{
    /**
     * The PermissionSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PermissionSet[]
     */
    public $PermissionSet;
    /**
     * Constructor method for PermissionSets
     * @uses PermissionSets::setPermissionSet()
     * @param \App\Library\ExactTarget\StructType\PermissionSet[] $permissionSet
     */
    public function __construct(array $permissionSet = array())
    {
        $this
            ->setPermissionSet($permissionSet);
    }
    /**
     * Get PermissionSet value
     * @return \App\Library\ExactTarget\StructType\PermissionSet[]|null
     */
    public function getPermissionSet()
    {
        return $this->PermissionSet;
    }
    /**
     * Set PermissionSet value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PermissionSet[] $permissionSet
     * @return \App\Library\ExactTarget\StructType\PermissionSets
     */
    public function setPermissionSet(array $permissionSet = array())
    {
        foreach ($permissionSet as $permissionSetsPermissionSetItem) {
            // validation for constraint: itemType
            if (!$permissionSetsPermissionSetItem instanceof \App\Library\ExactTarget\StructType\PermissionSet) {
                throw new \InvalidArgumentException(sprintf('The PermissionSet property can only contain items of \App\Library\ExactTarget\StructType\PermissionSet, "%s" given', is_object($permissionSetsPermissionSetItem) ? get_class($permissionSetsPermissionSetItem) : gettype($permissionSetsPermissionSetItem)), __LINE__);
            }
        }
        $this->PermissionSet = $permissionSet;
        return $this;
    }
    /**
     * Add item to PermissionSet value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PermissionSet $item
     * @return \App\Library\ExactTarget\StructType\PermissionSets
     */
    public function addToPermissionSet(\App\Library\ExactTarget\StructType\PermissionSet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\PermissionSet) {
            throw new \InvalidArgumentException(sprintf('The PermissionSet property can only contain items of \App\Library\ExactTarget\StructType\PermissionSet, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PermissionSet[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\PermissionSets
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
