<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PerformResult StructType
 * @subpackage Structs
 */
class PerformResult extends Result
{
    /**
     * The Object
     * @var \App\Library\ExactTarget\StructType\APIObject
     */
    public $Object;
    /**
     * The Task
     * @var \App\Library\ExactTarget\StructType\TaskResult
     */
    public $Task;
    /**
     * The ProgramActivityInstanceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\}
     * @var string
     */
    public $ProgramActivityInstanceId;
    /**
     * Constructor method for PerformResult
     * @uses PerformResult::setObject()
     * @uses PerformResult::setTask()
     * @uses PerformResult::setProgramActivityInstanceId()
     * @param \App\Library\ExactTarget\StructType\APIObject $object
     * @param \App\Library\ExactTarget\StructType\TaskResult $task
     * @param string $programActivityInstanceId
     */
    public function __construct(\App\Library\ExactTarget\StructType\APIObject $object = null, \App\Library\ExactTarget\StructType\TaskResult $task = null, $programActivityInstanceId = null)
    {
        $this
            ->setObject($object)
            ->setTask($task)
            ->setProgramActivityInstanceId($programActivityInstanceId);
    }
    /**
     * Get Object value
     * @return \App\Library\ExactTarget\StructType\APIObject|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @param \App\Library\ExactTarget\StructType\APIObject $object
     * @return \App\Library\ExactTarget\StructType\PerformResult
     */
    public function setObject(\App\Library\ExactTarget\StructType\APIObject $object = null)
    {
        $this->Object = $object;
        return $this;
    }
    /**
     * Get Task value
     * @return \App\Library\ExactTarget\StructType\TaskResult|null
     */
    public function getTask()
    {
        return $this->Task;
    }
    /**
     * Set Task value
     * @param \App\Library\ExactTarget\StructType\TaskResult $task
     * @return \App\Library\ExactTarget\StructType\PerformResult
     */
    public function setTask(\App\Library\ExactTarget\StructType\TaskResult $task = null)
    {
        $this->Task = $task;
        return $this;
    }
    /**
     * Get ProgramActivityInstanceId value
     * @return string|null
     */
    public function getProgramActivityInstanceId()
    {
        return $this->ProgramActivityInstanceId;
    }
    /**
     * Set ProgramActivityInstanceId value
     * @param string $programActivityInstanceId
     * @return \App\Library\ExactTarget\StructType\PerformResult
     */
    public function setProgramActivityInstanceId($programActivityInstanceId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($programActivityInstanceId) && !preg_match('/\\{[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\\}/', $programActivityInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\}", "%s" given', var_export($programActivityInstanceId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($programActivityInstanceId) && !is_string($programActivityInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programActivityInstanceId)), __LINE__);
        }
        $this->ProgramActivityInstanceId = $programActivityInstanceId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\PerformResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
