<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PerformOptions StructType
 * @subpackage Structs
 */
class PerformOptions extends Options
{
    /**
     * The Explanation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Explanation;
    /**
     * The ProgramActivityInstanceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\}
     * @var string
     */
    public $ProgramActivityInstanceID;
    /**
     * Constructor method for PerformOptions
     * @uses PerformOptions::setExplanation()
     * @uses PerformOptions::setProgramActivityInstanceID()
     * @param string $explanation
     * @param string $programActivityInstanceID
     */
    public function __construct($explanation = null, $programActivityInstanceID = null)
    {
        $this
            ->setExplanation($explanation)
            ->setProgramActivityInstanceID($programActivityInstanceID);
    }
    /**
     * Get Explanation value
     * @return string|null
     */
    public function getExplanation()
    {
        return $this->Explanation;
    }
    /**
     * Set Explanation value
     * @param string $explanation
     * @return \App\Library\ExactTarget\StructType\PerformOptions
     */
    public function setExplanation($explanation = null)
    {
        // validation for constraint: string
        if (!is_null($explanation) && !is_string($explanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($explanation)), __LINE__);
        }
        $this->Explanation = $explanation;
        return $this;
    }
    /**
     * Get ProgramActivityInstanceID value
     * @return string|null
     */
    public function getProgramActivityInstanceID()
    {
        return $this->ProgramActivityInstanceID;
    }
    /**
     * Set ProgramActivityInstanceID value
     * @param string $programActivityInstanceID
     * @return \App\Library\ExactTarget\StructType\PerformOptions
     */
    public function setProgramActivityInstanceID($programActivityInstanceID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($programActivityInstanceID) && !preg_match('/\\{[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\\}/', $programActivityInstanceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\}", "%s" given', var_export($programActivityInstanceID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($programActivityInstanceID) && !is_string($programActivityInstanceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programActivityInstanceID)), __LINE__);
        }
        $this->ProgramActivityInstanceID = $programActivityInstanceID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\PerformOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
