<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectExtension StructType
 * @subpackage Structs
 */
class ObjectExtension extends APIObject
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Properties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Properties
     */
    public $Properties;
    /**
     * Constructor method for ObjectExtension
     * @uses ObjectExtension::setType()
     * @uses ObjectExtension::setProperties()
     * @param string $type
     * @param \App\Library\ExactTarget\StructType\Properties $properties
     */
    public function __construct($type = null, \App\Library\ExactTarget\StructType\Properties $properties = null)
    {
        $this
            ->setType($type)
            ->setProperties($properties);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \App\Library\ExactTarget\StructType\ObjectExtension
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Properties value
     * @return \App\Library\ExactTarget\StructType\Properties|null
     */
    public function getProperties()
    {
        return $this->Properties;
    }
    /**
     * Set Properties value
     * @param \App\Library\ExactTarget\StructType\Properties $properties
     * @return \App\Library\ExactTarget\StructType\ObjectExtension
     */
    public function setProperties(\App\Library\ExactTarget\StructType\Properties $properties = null)
    {
        $this->Properties = $properties;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ObjectExtension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
