<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectDefinitionRequest StructType
 * @subpackage Structs
 */
class ObjectDefinitionRequest extends AbstractStructBase
{
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ClientID
     */
    public $Client;
    /**
     * The ObjectType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObjectType;
    /**
     * Constructor method for ObjectDefinitionRequest
     * @uses ObjectDefinitionRequest::setClient()
     * @uses ObjectDefinitionRequest::setObjectType()
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @param string $objectType
     */
    public function __construct(\App\Library\ExactTarget\StructType\ClientID $client = null, $objectType = null)
    {
        $this
            ->setClient($client)
            ->setObjectType($objectType);
    }
    /**
     * Get Client value
     * @return \App\Library\ExactTarget\StructType\ClientID|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @return \App\Library\ExactTarget\StructType\ObjectDefinitionRequest
     */
    public function setClient(\App\Library\ExactTarget\StructType\ClientID $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get ObjectType value
     * @return string|null
     */
    public function getObjectType()
    {
        return $this->ObjectType;
    }
    /**
     * Set ObjectType value
     * @param string $objectType
     * @return \App\Library\ExactTarget\StructType\ObjectDefinitionRequest
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectType)), __LINE__);
        }
        $this->ObjectType = $objectType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ObjectDefinitionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
