<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonthlyRecurrence StructType
 * Meta informations extracted from the WSDL
 * - type: tns:MonthlyRecurrence
 * @subpackage Structs
 */
class MonthlyRecurrence extends Recurrence
{
    /**
     * The MonthlyRecurrencePatternType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MonthlyRecurrencePatternType;
    /**
     * The MonthlyInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MonthlyInterval;
    /**
     * The ScheduledDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ScheduledDay;
    /**
     * The ScheduledWeek
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledWeek;
    /**
     * The ScheduledDayOfWeek
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledDayOfWeek;
    /**
     * Constructor method for MonthlyRecurrence
     * @uses MonthlyRecurrence::setMonthlyRecurrencePatternType()
     * @uses MonthlyRecurrence::setMonthlyInterval()
     * @uses MonthlyRecurrence::setScheduledDay()
     * @uses MonthlyRecurrence::setScheduledWeek()
     * @uses MonthlyRecurrence::setScheduledDayOfWeek()
     * @param string $monthlyRecurrencePatternType
     * @param int $monthlyInterval
     * @param int $scheduledDay
     * @param string $scheduledWeek
     * @param string $scheduledDayOfWeek
     */
    public function __construct($monthlyRecurrencePatternType = null, $monthlyInterval = null, $scheduledDay = null, $scheduledWeek = null, $scheduledDayOfWeek = null)
    {
        $this
            ->setMonthlyRecurrencePatternType($monthlyRecurrencePatternType)
            ->setMonthlyInterval($monthlyInterval)
            ->setScheduledDay($scheduledDay)
            ->setScheduledWeek($scheduledWeek)
            ->setScheduledDayOfWeek($scheduledDayOfWeek);
    }
    /**
     * Get MonthlyRecurrencePatternType value
     * @return string|null
     */
    public function getMonthlyRecurrencePatternType()
    {
        return $this->MonthlyRecurrencePatternType;
    }
    /**
     * Set MonthlyRecurrencePatternType value
     * @uses \App\Library\ExactTarget\EnumType\MonthlyRecurrencePatternTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\MonthlyRecurrencePatternTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthlyRecurrencePatternType
     * @return \App\Library\ExactTarget\StructType\MonthlyRecurrence
     */
    public function setMonthlyRecurrencePatternType($monthlyRecurrencePatternType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\MonthlyRecurrencePatternTypeEnum::valueIsValid($monthlyRecurrencePatternType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $monthlyRecurrencePatternType, implode(', ', \App\Library\ExactTarget\EnumType\MonthlyRecurrencePatternTypeEnum::getValidValues())), __LINE__);
        }
        $this->MonthlyRecurrencePatternType = $monthlyRecurrencePatternType;
        return $this;
    }
    /**
     * Get MonthlyInterval value
     * @return int|null
     */
    public function getMonthlyInterval()
    {
        return $this->MonthlyInterval;
    }
    /**
     * Set MonthlyInterval value
     * @param int $monthlyInterval
     * @return \App\Library\ExactTarget\StructType\MonthlyRecurrence
     */
    public function setMonthlyInterval($monthlyInterval = null)
    {
        // validation for constraint: int
        if (!is_null($monthlyInterval) && !is_numeric($monthlyInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($monthlyInterval)), __LINE__);
        }
        $this->MonthlyInterval = $monthlyInterval;
        return $this;
    }
    /**
     * Get ScheduledDay value
     * @return int|null
     */
    public function getScheduledDay()
    {
        return $this->ScheduledDay;
    }
    /**
     * Set ScheduledDay value
     * @param int $scheduledDay
     * @return \App\Library\ExactTarget\StructType\MonthlyRecurrence
     */
    public function setScheduledDay($scheduledDay = null)
    {
        // validation for constraint: int
        if (!is_null($scheduledDay) && !is_numeric($scheduledDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scheduledDay)), __LINE__);
        }
        $this->ScheduledDay = $scheduledDay;
        return $this;
    }
    /**
     * Get ScheduledWeek value
     * @return string|null
     */
    public function getScheduledWeek()
    {
        return $this->ScheduledWeek;
    }
    /**
     * Set ScheduledWeek value
     * @uses \App\Library\ExactTarget\EnumType\WeekOfMonthEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\WeekOfMonthEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduledWeek
     * @return \App\Library\ExactTarget\StructType\MonthlyRecurrence
     */
    public function setScheduledWeek($scheduledWeek = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\WeekOfMonthEnum::valueIsValid($scheduledWeek)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scheduledWeek, implode(', ', \App\Library\ExactTarget\EnumType\WeekOfMonthEnum::getValidValues())), __LINE__);
        }
        $this->ScheduledWeek = $scheduledWeek;
        return $this;
    }
    /**
     * Get ScheduledDayOfWeek value
     * @return string|null
     */
    public function getScheduledDayOfWeek()
    {
        return $this->ScheduledDayOfWeek;
    }
    /**
     * Set ScheduledDayOfWeek value
     * @uses \App\Library\ExactTarget\EnumType\DayOfWeekEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DayOfWeekEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduledDayOfWeek
     * @return \App\Library\ExactTarget\StructType\MonthlyRecurrence
     */
    public function setScheduledDayOfWeek($scheduledDayOfWeek = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DayOfWeekEnum::valueIsValid($scheduledDayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scheduledDayOfWeek, implode(', ', \App\Library\ExactTarget\EnumType\DayOfWeekEnum::getValidValues())), __LINE__);
        }
        $this->ScheduledDayOfWeek = $scheduledDayOfWeek;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\MonthlyRecurrence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
