<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessagingConfiguration StructType
 * Meta informations extracted from the WSDL
 * - documentation: Deprecated.
 * @subpackage Structs
 */
class MessagingConfiguration extends APIObject
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Code;
    /**
     * The MessagingVendorKind
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\MessagingVendorKind
     */
    public $MessagingVendorKind;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Url;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Password;
    /**
     * The ProfileID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProfileID;
    /**
     * The CallbackUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CallbackUrl;
    /**
     * The MediaTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MediaTypes;
    /**
     * Constructor method for MessagingConfiguration
     * @uses MessagingConfiguration::setCode()
     * @uses MessagingConfiguration::setMessagingVendorKind()
     * @uses MessagingConfiguration::setIsActive()
     * @uses MessagingConfiguration::setUrl()
     * @uses MessagingConfiguration::setUserName()
     * @uses MessagingConfiguration::setPassword()
     * @uses MessagingConfiguration::setProfileID()
     * @uses MessagingConfiguration::setCallbackUrl()
     * @uses MessagingConfiguration::setMediaTypes()
     * @param string $code
     * @param \App\Library\ExactTarget\StructType\MessagingVendorKind $messagingVendorKind
     * @param bool $isActive
     * @param string $url
     * @param string $userName
     * @param string $password
     * @param string $profileID
     * @param string $callbackUrl
     * @param string $mediaTypes
     */
    public function __construct($code = null, \App\Library\ExactTarget\StructType\MessagingVendorKind $messagingVendorKind = null, $isActive = null, $url = null, $userName = null, $password = null, $profileID = null, $callbackUrl = null, $mediaTypes = null)
    {
        $this
            ->setCode($code)
            ->setMessagingVendorKind($messagingVendorKind)
            ->setIsActive($isActive)
            ->setUrl($url)
            ->setUserName($userName)
            ->setPassword($password)
            ->setProfileID($profileID)
            ->setCallbackUrl($callbackUrl)
            ->setMediaTypes($mediaTypes);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \App\Library\ExactTarget\StructType\MessagingConfiguration
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get MessagingVendorKind value
     * @return \App\Library\ExactTarget\StructType\MessagingVendorKind
     */
    public function getMessagingVendorKind()
    {
        return $this->MessagingVendorKind;
    }
    /**
     * Set MessagingVendorKind value
     * @param \App\Library\ExactTarget\StructType\MessagingVendorKind $messagingVendorKind
     * @return \App\Library\ExactTarget\StructType\MessagingConfiguration
     */
    public function setMessagingVendorKind(\App\Library\ExactTarget\StructType\MessagingVendorKind $messagingVendorKind = null)
    {
        $this->MessagingVendorKind = $messagingVendorKind;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \App\Library\ExactTarget\StructType\MessagingConfiguration
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Url value
     * @return string
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \App\Library\ExactTarget\StructType\MessagingConfiguration
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get UserName value
     * @return string
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \App\Library\ExactTarget\StructType\MessagingConfiguration
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \App\Library\ExactTarget\StructType\MessagingConfiguration
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return string
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param string $profileID
     * @return \App\Library\ExactTarget\StructType\MessagingConfiguration
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: string
        if (!is_null($profileID) && !is_string($profileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get CallbackUrl value
     * @return string|null
     */
    public function getCallbackUrl()
    {
        return $this->CallbackUrl;
    }
    /**
     * Set CallbackUrl value
     * @param string $callbackUrl
     * @return \App\Library\ExactTarget\StructType\MessagingConfiguration
     */
    public function setCallbackUrl($callbackUrl = null)
    {
        // validation for constraint: string
        if (!is_null($callbackUrl) && !is_string($callbackUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callbackUrl)), __LINE__);
        }
        $this->CallbackUrl = $callbackUrl;
        return $this;
    }
    /**
     * Get MediaTypes value
     * @return string|null
     */
    public function getMediaTypes()
    {
        return $this->MediaTypes;
    }
    /**
     * Set MediaTypes value
     * @param string $mediaTypes
     * @return \App\Library\ExactTarget\StructType\MessagingConfiguration
     */
    public function setMediaTypes($mediaTypes = null)
    {
        // validation for constraint: string
        if (!is_null($mediaTypes) && !is_string($mediaTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mediaTypes)), __LINE__);
        }
        $this->MediaTypes = $mediaTypes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\MessagingConfiguration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
