<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListSend StructType
 * @subpackage Structs
 */
class ListSend extends APIObject
{
    /**
     * The SendID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SendID;
    /**
     * The List
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\_List
     */
    public $List;
    /**
     * The Duplicates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Duplicates;
    /**
     * The InvalidAddresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $InvalidAddresses;
    /**
     * The ExistingUndeliverables
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ExistingUndeliverables;
    /**
     * The ExistingUnsubscribes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ExistingUnsubscribes;
    /**
     * The HardBounces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $HardBounces;
    /**
     * The SoftBounces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SoftBounces;
    /**
     * The OtherBounces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OtherBounces;
    /**
     * The ForwardedEmails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ForwardedEmails;
    /**
     * The UniqueClicks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $UniqueClicks;
    /**
     * The UniqueOpens
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $UniqueOpens;
    /**
     * The NumberSent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberSent;
    /**
     * The NumberDelivered
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberDelivered;
    /**
     * The Unsubscribes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Unsubscribes;
    /**
     * The MissingAddresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MissingAddresses;
    /**
     * The PreviewURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreviewURL;
    /**
     * The Links
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Link[]
     */
    public $Links;
    /**
     * The Events
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TrackingEvent[]
     */
    public $Events;
    /**
     * Constructor method for ListSend
     * @uses ListSend::setSendID()
     * @uses ListSend::setList()
     * @uses ListSend::setDuplicates()
     * @uses ListSend::setInvalidAddresses()
     * @uses ListSend::setExistingUndeliverables()
     * @uses ListSend::setExistingUnsubscribes()
     * @uses ListSend::setHardBounces()
     * @uses ListSend::setSoftBounces()
     * @uses ListSend::setOtherBounces()
     * @uses ListSend::setForwardedEmails()
     * @uses ListSend::setUniqueClicks()
     * @uses ListSend::setUniqueOpens()
     * @uses ListSend::setNumberSent()
     * @uses ListSend::setNumberDelivered()
     * @uses ListSend::setUnsubscribes()
     * @uses ListSend::setMissingAddresses()
     * @uses ListSend::setPreviewURL()
     * @uses ListSend::setLinks()
     * @uses ListSend::setEvents()
     * @param int $sendID
     * @param \App\Library\ExactTarget\StructType\_List $list
     * @param int $duplicates
     * @param int $invalidAddresses
     * @param int $existingUndeliverables
     * @param int $existingUnsubscribes
     * @param int $hardBounces
     * @param int $softBounces
     * @param int $otherBounces
     * @param int $forwardedEmails
     * @param int $uniqueClicks
     * @param int $uniqueOpens
     * @param int $numberSent
     * @param int $numberDelivered
     * @param int $unsubscribes
     * @param int $missingAddresses
     * @param string $previewURL
     * @param \App\Library\ExactTarget\StructType\Link[] $links
     * @param \App\Library\ExactTarget\StructType\TrackingEvent[] $events
     */
    public function __construct($sendID = null, \App\Library\ExactTarget\StructType\_List $list = null, $duplicates = null, $invalidAddresses = null, $existingUndeliverables = null, $existingUnsubscribes = null, $hardBounces = null, $softBounces = null, $otherBounces = null, $forwardedEmails = null, $uniqueClicks = null, $uniqueOpens = null, $numberSent = null, $numberDelivered = null, $unsubscribes = null, $missingAddresses = null, $previewURL = null, array $links = array(), array $events = array())
    {
        $this
            ->setSendID($sendID)
            ->setList($list)
            ->setDuplicates($duplicates)
            ->setInvalidAddresses($invalidAddresses)
            ->setExistingUndeliverables($existingUndeliverables)
            ->setExistingUnsubscribes($existingUnsubscribes)
            ->setHardBounces($hardBounces)
            ->setSoftBounces($softBounces)
            ->setOtherBounces($otherBounces)
            ->setForwardedEmails($forwardedEmails)
            ->setUniqueClicks($uniqueClicks)
            ->setUniqueOpens($uniqueOpens)
            ->setNumberSent($numberSent)
            ->setNumberDelivered($numberDelivered)
            ->setUnsubscribes($unsubscribes)
            ->setMissingAddresses($missingAddresses)
            ->setPreviewURL($previewURL)
            ->setLinks($links)
            ->setEvents($events);
    }
    /**
     * Get SendID value
     * @return int|null
     */
    public function getSendID()
    {
        return $this->SendID;
    }
    /**
     * Set SendID value
     * @param int $sendID
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setSendID($sendID = null)
    {
        // validation for constraint: int
        if (!is_null($sendID) && !is_numeric($sendID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sendID)), __LINE__);
        }
        $this->SendID = $sendID;
        return $this;
    }
    /**
     * Get List value
     * @return \App\Library\ExactTarget\StructType\_List|null
     */
    public function getList()
    {
        return $this->List;
    }
    /**
     * Set List value
     * @param \App\Library\ExactTarget\StructType\_List $list
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setList(\App\Library\ExactTarget\StructType\_List $list = null)
    {
        $this->List = $list;
        return $this;
    }
    /**
     * Get Duplicates value
     * @return int|null
     */
    public function getDuplicates()
    {
        return $this->Duplicates;
    }
    /**
     * Set Duplicates value
     * @param int $duplicates
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setDuplicates($duplicates = null)
    {
        // validation for constraint: int
        if (!is_null($duplicates) && !is_numeric($duplicates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duplicates)), __LINE__);
        }
        $this->Duplicates = $duplicates;
        return $this;
    }
    /**
     * Get InvalidAddresses value
     * @return int|null
     */
    public function getInvalidAddresses()
    {
        return $this->InvalidAddresses;
    }
    /**
     * Set InvalidAddresses value
     * @param int $invalidAddresses
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setInvalidAddresses($invalidAddresses = null)
    {
        // validation for constraint: int
        if (!is_null($invalidAddresses) && !is_numeric($invalidAddresses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invalidAddresses)), __LINE__);
        }
        $this->InvalidAddresses = $invalidAddresses;
        return $this;
    }
    /**
     * Get ExistingUndeliverables value
     * @return int|null
     */
    public function getExistingUndeliverables()
    {
        return $this->ExistingUndeliverables;
    }
    /**
     * Set ExistingUndeliverables value
     * @param int $existingUndeliverables
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setExistingUndeliverables($existingUndeliverables = null)
    {
        // validation for constraint: int
        if (!is_null($existingUndeliverables) && !is_numeric($existingUndeliverables)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($existingUndeliverables)), __LINE__);
        }
        $this->ExistingUndeliverables = $existingUndeliverables;
        return $this;
    }
    /**
     * Get ExistingUnsubscribes value
     * @return int|null
     */
    public function getExistingUnsubscribes()
    {
        return $this->ExistingUnsubscribes;
    }
    /**
     * Set ExistingUnsubscribes value
     * @param int $existingUnsubscribes
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setExistingUnsubscribes($existingUnsubscribes = null)
    {
        // validation for constraint: int
        if (!is_null($existingUnsubscribes) && !is_numeric($existingUnsubscribes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($existingUnsubscribes)), __LINE__);
        }
        $this->ExistingUnsubscribes = $existingUnsubscribes;
        return $this;
    }
    /**
     * Get HardBounces value
     * @return int|null
     */
    public function getHardBounces()
    {
        return $this->HardBounces;
    }
    /**
     * Set HardBounces value
     * @param int $hardBounces
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setHardBounces($hardBounces = null)
    {
        // validation for constraint: int
        if (!is_null($hardBounces) && !is_numeric($hardBounces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hardBounces)), __LINE__);
        }
        $this->HardBounces = $hardBounces;
        return $this;
    }
    /**
     * Get SoftBounces value
     * @return int|null
     */
    public function getSoftBounces()
    {
        return $this->SoftBounces;
    }
    /**
     * Set SoftBounces value
     * @param int $softBounces
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setSoftBounces($softBounces = null)
    {
        // validation for constraint: int
        if (!is_null($softBounces) && !is_numeric($softBounces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($softBounces)), __LINE__);
        }
        $this->SoftBounces = $softBounces;
        return $this;
    }
    /**
     * Get OtherBounces value
     * @return int|null
     */
    public function getOtherBounces()
    {
        return $this->OtherBounces;
    }
    /**
     * Set OtherBounces value
     * @param int $otherBounces
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setOtherBounces($otherBounces = null)
    {
        // validation for constraint: int
        if (!is_null($otherBounces) && !is_numeric($otherBounces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($otherBounces)), __LINE__);
        }
        $this->OtherBounces = $otherBounces;
        return $this;
    }
    /**
     * Get ForwardedEmails value
     * @return int|null
     */
    public function getForwardedEmails()
    {
        return $this->ForwardedEmails;
    }
    /**
     * Set ForwardedEmails value
     * @param int $forwardedEmails
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setForwardedEmails($forwardedEmails = null)
    {
        // validation for constraint: int
        if (!is_null($forwardedEmails) && !is_numeric($forwardedEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($forwardedEmails)), __LINE__);
        }
        $this->ForwardedEmails = $forwardedEmails;
        return $this;
    }
    /**
     * Get UniqueClicks value
     * @return int|null
     */
    public function getUniqueClicks()
    {
        return $this->UniqueClicks;
    }
    /**
     * Set UniqueClicks value
     * @param int $uniqueClicks
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setUniqueClicks($uniqueClicks = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueClicks) && !is_numeric($uniqueClicks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uniqueClicks)), __LINE__);
        }
        $this->UniqueClicks = $uniqueClicks;
        return $this;
    }
    /**
     * Get UniqueOpens value
     * @return int|null
     */
    public function getUniqueOpens()
    {
        return $this->UniqueOpens;
    }
    /**
     * Set UniqueOpens value
     * @param int $uniqueOpens
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setUniqueOpens($uniqueOpens = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueOpens) && !is_numeric($uniqueOpens)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uniqueOpens)), __LINE__);
        }
        $this->UniqueOpens = $uniqueOpens;
        return $this;
    }
    /**
     * Get NumberSent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberSent()
    {
        return isset($this->NumberSent) ? $this->NumberSent : null;
    }
    /**
     * Set NumberSent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberSent
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setNumberSent($numberSent = null)
    {
        // validation for constraint: int
        if (!is_null($numberSent) && !is_numeric($numberSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberSent)), __LINE__);
        }
        if (is_null($numberSent) || (is_array($numberSent) && empty($numberSent))) {
            unset($this->NumberSent);
        } else {
            $this->NumberSent = $numberSent;
        }
        return $this;
    }
    /**
     * Get NumberDelivered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberDelivered()
    {
        return isset($this->NumberDelivered) ? $this->NumberDelivered : null;
    }
    /**
     * Set NumberDelivered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberDelivered
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setNumberDelivered($numberDelivered = null)
    {
        // validation for constraint: int
        if (!is_null($numberDelivered) && !is_numeric($numberDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberDelivered)), __LINE__);
        }
        if (is_null($numberDelivered) || (is_array($numberDelivered) && empty($numberDelivered))) {
            unset($this->NumberDelivered);
        } else {
            $this->NumberDelivered = $numberDelivered;
        }
        return $this;
    }
    /**
     * Get Unsubscribes value
     * @return int|null
     */
    public function getUnsubscribes()
    {
        return $this->Unsubscribes;
    }
    /**
     * Set Unsubscribes value
     * @param int $unsubscribes
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setUnsubscribes($unsubscribes = null)
    {
        // validation for constraint: int
        if (!is_null($unsubscribes) && !is_numeric($unsubscribes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unsubscribes)), __LINE__);
        }
        $this->Unsubscribes = $unsubscribes;
        return $this;
    }
    /**
     * Get MissingAddresses value
     * @return int|null
     */
    public function getMissingAddresses()
    {
        return $this->MissingAddresses;
    }
    /**
     * Set MissingAddresses value
     * @param int $missingAddresses
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setMissingAddresses($missingAddresses = null)
    {
        // validation for constraint: int
        if (!is_null($missingAddresses) && !is_numeric($missingAddresses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($missingAddresses)), __LINE__);
        }
        $this->MissingAddresses = $missingAddresses;
        return $this;
    }
    /**
     * Get PreviewURL value
     * @return string|null
     */
    public function getPreviewURL()
    {
        return $this->PreviewURL;
    }
    /**
     * Set PreviewURL value
     * @param string $previewURL
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setPreviewURL($previewURL = null)
    {
        // validation for constraint: string
        if (!is_null($previewURL) && !is_string($previewURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previewURL)), __LINE__);
        }
        $this->PreviewURL = $previewURL;
        return $this;
    }
    /**
     * Get Links value
     * @return \App\Library\ExactTarget\StructType\Link[]|null
     */
    public function getLinks()
    {
        return $this->Links;
    }
    /**
     * Set Links value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Link[] $links
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setLinks(array $links = array())
    {
        foreach ($links as $listSendLinksItem) {
            // validation for constraint: itemType
            if (!$listSendLinksItem instanceof \App\Library\ExactTarget\StructType\Link) {
                throw new \InvalidArgumentException(sprintf('The Links property can only contain items of \App\Library\ExactTarget\StructType\Link, "%s" given', is_object($listSendLinksItem) ? get_class($listSendLinksItem) : gettype($listSendLinksItem)), __LINE__);
            }
        }
        $this->Links = $links;
        return $this;
    }
    /**
     * Add item to Links value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Link $item
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function addToLinks(\App\Library\ExactTarget\StructType\Link $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Link) {
            throw new \InvalidArgumentException(sprintf('The Links property can only contain items of \App\Library\ExactTarget\StructType\Link, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Links[] = $item;
        return $this;
    }
    /**
     * Get Events value
     * @return \App\Library\ExactTarget\StructType\TrackingEvent[]|null
     */
    public function getEvents()
    {
        return $this->Events;
    }
    /**
     * Set Events value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\TrackingEvent[] $events
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function setEvents(array $events = array())
    {
        foreach ($events as $listSendEventsItem) {
            // validation for constraint: itemType
            if (!$listSendEventsItem instanceof \App\Library\ExactTarget\StructType\TrackingEvent) {
                throw new \InvalidArgumentException(sprintf('The Events property can only contain items of \App\Library\ExactTarget\StructType\TrackingEvent, "%s" given', is_object($listSendEventsItem) ? get_class($listSendEventsItem) : gettype($listSendEventsItem)), __LINE__);
            }
        }
        $this->Events = $events;
        return $this;
    }
    /**
     * Add item to Events value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\TrackingEvent $item
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public function addToEvents(\App\Library\ExactTarget\StructType\TrackingEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\TrackingEvent) {
            throw new \InvalidArgumentException(sprintf('The Events property can only contain items of \App\Library\ExactTarget\StructType\TrackingEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Events[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ListSend
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
