<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListAttribute StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ListAttribute
 * @subpackage Structs
 */
class ListAttribute extends APIObject
{
    /**
     * The List
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\_List
     */
    public $List;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The FieldType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldType;
    /**
     * The FieldLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $FieldLength;
    /**
     * The Scale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Scale;
    /**
     * The MinValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MinValue;
    /**
     * The MaxValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaxValue;
    /**
     * The DefaultValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultValue;
    /**
     * The IsNullable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsNullable;
    /**
     * The IsHidden
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsHidden;
    /**
     * The IsReadOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsReadOnly;
    /**
     * The Inheritable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inheritable;
    /**
     * The Overridable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Overridable;
    /**
     * The MustOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MustOverride;
    /**
     * The OverrideType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OverrideType;
    /**
     * The Ordinal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * The RestrictedValues
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue[]
     */
    public $RestrictedValues;
    /**
     * The BaseAttribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ListAttribute
     */
    public $BaseAttribute;
    /**
     * Constructor method for ListAttribute
     * @uses ListAttribute::setList()
     * @uses ListAttribute::setName()
     * @uses ListAttribute::setDescription()
     * @uses ListAttribute::setFieldType()
     * @uses ListAttribute::setFieldLength()
     * @uses ListAttribute::setScale()
     * @uses ListAttribute::setMinValue()
     * @uses ListAttribute::setMaxValue()
     * @uses ListAttribute::setDefaultValue()
     * @uses ListAttribute::setIsNullable()
     * @uses ListAttribute::setIsHidden()
     * @uses ListAttribute::setIsReadOnly()
     * @uses ListAttribute::setInheritable()
     * @uses ListAttribute::setOverridable()
     * @uses ListAttribute::setMustOverride()
     * @uses ListAttribute::setOverrideType()
     * @uses ListAttribute::setOrdinal()
     * @uses ListAttribute::setRestrictedValues()
     * @uses ListAttribute::setBaseAttribute()
     * @param \App\Library\ExactTarget\StructType\_List $list
     * @param string $name
     * @param string $description
     * @param string $fieldType
     * @param int $fieldLength
     * @param int $scale
     * @param string $minValue
     * @param string $maxValue
     * @param string $defaultValue
     * @param bool $isNullable
     * @param bool $isHidden
     * @param bool $isReadOnly
     * @param bool $inheritable
     * @param bool $overridable
     * @param bool $mustOverride
     * @param string $overrideType
     * @param int $ordinal
     * @param \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue[] $restrictedValues
     * @param \App\Library\ExactTarget\StructType\ListAttribute $baseAttribute
     */
    public function __construct(\App\Library\ExactTarget\StructType\_List $list = null, $name = null, $description = null, $fieldType = null, $fieldLength = null, $scale = null, $minValue = null, $maxValue = null, $defaultValue = null, $isNullable = null, $isHidden = null, $isReadOnly = null, $inheritable = null, $overridable = null, $mustOverride = null, $overrideType = null, $ordinal = null, array $restrictedValues = array(), \App\Library\ExactTarget\StructType\ListAttribute $baseAttribute = null)
    {
        $this
            ->setList($list)
            ->setName($name)
            ->setDescription($description)
            ->setFieldType($fieldType)
            ->setFieldLength($fieldLength)
            ->setScale($scale)
            ->setMinValue($minValue)
            ->setMaxValue($maxValue)
            ->setDefaultValue($defaultValue)
            ->setIsNullable($isNullable)
            ->setIsHidden($isHidden)
            ->setIsReadOnly($isReadOnly)
            ->setInheritable($inheritable)
            ->setOverridable($overridable)
            ->setMustOverride($mustOverride)
            ->setOverrideType($overrideType)
            ->setOrdinal($ordinal)
            ->setRestrictedValues($restrictedValues)
            ->setBaseAttribute($baseAttribute);
    }
    /**
     * Get List value
     * @return \App\Library\ExactTarget\StructType\_List|null
     */
    public function getList()
    {
        return $this->List;
    }
    /**
     * Set List value
     * @param \App\Library\ExactTarget\StructType\_List $list
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setList(\App\Library\ExactTarget\StructType\_List $list = null)
    {
        $this->List = $list;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FieldType value
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->FieldType;
    }
    /**
     * Set FieldType value
     * @uses \App\Library\ExactTarget\EnumType\ListAttributeFieldType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\ListAttributeFieldType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fieldType
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setFieldType($fieldType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\ListAttributeFieldType::valueIsValid($fieldType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fieldType, implode(', ', \App\Library\ExactTarget\EnumType\ListAttributeFieldType::getValidValues())), __LINE__);
        }
        $this->FieldType = $fieldType;
        return $this;
    }
    /**
     * Get FieldLength value
     * @return int|null
     */
    public function getFieldLength()
    {
        return $this->FieldLength;
    }
    /**
     * Set FieldLength value
     * @param int $fieldLength
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setFieldLength($fieldLength = null)
    {
        // validation for constraint: int
        if (!is_null($fieldLength) && !is_numeric($fieldLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fieldLength)), __LINE__);
        }
        $this->FieldLength = $fieldLength;
        return $this;
    }
    /**
     * Get Scale value
     * @return int|null
     */
    public function getScale()
    {
        return $this->Scale;
    }
    /**
     * Set Scale value
     * @param int $scale
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setScale($scale = null)
    {
        // validation for constraint: int
        if (!is_null($scale) && !is_numeric($scale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scale)), __LINE__);
        }
        $this->Scale = $scale;
        return $this;
    }
    /**
     * Get MinValue value
     * @return string|null
     */
    public function getMinValue()
    {
        return $this->MinValue;
    }
    /**
     * Set MinValue value
     * @param string $minValue
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setMinValue($minValue = null)
    {
        // validation for constraint: string
        if (!is_null($minValue) && !is_string($minValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minValue)), __LINE__);
        }
        $this->MinValue = $minValue;
        return $this;
    }
    /**
     * Get MaxValue value
     * @return string|null
     */
    public function getMaxValue()
    {
        return $this->MaxValue;
    }
    /**
     * Set MaxValue value
     * @param string $maxValue
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setMaxValue($maxValue = null)
    {
        // validation for constraint: string
        if (!is_null($maxValue) && !is_string($maxValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxValue)), __LINE__);
        }
        $this->MaxValue = $maxValue;
        return $this;
    }
    /**
     * Get DefaultValue value
     * @return string|null
     */
    public function getDefaultValue()
    {
        return $this->DefaultValue;
    }
    /**
     * Set DefaultValue value
     * @param string $defaultValue
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: string
        if (!is_null($defaultValue) && !is_string($defaultValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultValue)), __LINE__);
        }
        $this->DefaultValue = $defaultValue;
        return $this;
    }
    /**
     * Get IsNullable value
     * @return bool|null
     */
    public function getIsNullable()
    {
        return $this->IsNullable;
    }
    /**
     * Set IsNullable value
     * @param bool $isNullable
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setIsNullable($isNullable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNullable) && !is_bool($isNullable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNullable)), __LINE__);
        }
        $this->IsNullable = $isNullable;
        return $this;
    }
    /**
     * Get IsHidden value
     * @return bool|null
     */
    public function getIsHidden()
    {
        return $this->IsHidden;
    }
    /**
     * Set IsHidden value
     * @param bool $isHidden
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isHidden)), __LINE__);
        }
        $this->IsHidden = $isHidden;
        return $this;
    }
    /**
     * Get IsReadOnly value
     * @return bool|null
     */
    public function getIsReadOnly()
    {
        return $this->IsReadOnly;
    }
    /**
     * Set IsReadOnly value
     * @param bool $isReadOnly
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setIsReadOnly($isReadOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReadOnly) && !is_bool($isReadOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isReadOnly)), __LINE__);
        }
        $this->IsReadOnly = $isReadOnly;
        return $this;
    }
    /**
     * Get Inheritable value
     * @return bool|null
     */
    public function getInheritable()
    {
        return $this->Inheritable;
    }
    /**
     * Set Inheritable value
     * @param bool $inheritable
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setInheritable($inheritable = null)
    {
        // validation for constraint: boolean
        if (!is_null($inheritable) && !is_bool($inheritable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inheritable)), __LINE__);
        }
        $this->Inheritable = $inheritable;
        return $this;
    }
    /**
     * Get Overridable value
     * @return bool|null
     */
    public function getOverridable()
    {
        return $this->Overridable;
    }
    /**
     * Set Overridable value
     * @param bool $overridable
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setOverridable($overridable = null)
    {
        // validation for constraint: boolean
        if (!is_null($overridable) && !is_bool($overridable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overridable)), __LINE__);
        }
        $this->Overridable = $overridable;
        return $this;
    }
    /**
     * Get MustOverride value
     * @return bool|null
     */
    public function getMustOverride()
    {
        return $this->MustOverride;
    }
    /**
     * Set MustOverride value
     * @param bool $mustOverride
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setMustOverride($mustOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustOverride) && !is_bool($mustOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mustOverride)), __LINE__);
        }
        $this->MustOverride = $mustOverride;
        return $this;
    }
    /**
     * Get OverrideType value
     * @return string|null
     */
    public function getOverrideType()
    {
        return $this->OverrideType;
    }
    /**
     * Set OverrideType value
     * @uses \App\Library\ExactTarget\EnumType\OverrideType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\OverrideType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overrideType
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setOverrideType($overrideType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\OverrideType::valueIsValid($overrideType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $overrideType, implode(', ', \App\Library\ExactTarget\EnumType\OverrideType::getValidValues())), __LINE__);
        }
        $this->OverrideType = $overrideType;
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !is_numeric($ordinal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get RestrictedValues value
     * @return \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue[]|null
     */
    public function getRestrictedValues()
    {
        return $this->RestrictedValues;
    }
    /**
     * Set RestrictedValues value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue[] $restrictedValues
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setRestrictedValues(array $restrictedValues = array())
    {
        foreach ($restrictedValues as $listAttributeRestrictedValuesItem) {
            // validation for constraint: itemType
            if (!$listAttributeRestrictedValuesItem instanceof \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue) {
                throw new \InvalidArgumentException(sprintf('The RestrictedValues property can only contain items of \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue, "%s" given', is_object($listAttributeRestrictedValuesItem) ? get_class($listAttributeRestrictedValuesItem) : gettype($listAttributeRestrictedValuesItem)), __LINE__);
            }
        }
        $this->RestrictedValues = $restrictedValues;
        return $this;
    }
    /**
     * Add item to RestrictedValues value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue $item
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function addToRestrictedValues(\App\Library\ExactTarget\StructType\ListAttributeRestrictedValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue) {
            throw new \InvalidArgumentException(sprintf('The RestrictedValues property can only contain items of \App\Library\ExactTarget\StructType\ListAttributeRestrictedValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RestrictedValues[] = $item;
        return $this;
    }
    /**
     * Get BaseAttribute value
     * @return \App\Library\ExactTarget\StructType\ListAttribute|null
     */
    public function getBaseAttribute()
    {
        return $this->BaseAttribute;
    }
    /**
     * Set BaseAttribute value
     * @param \App\Library\ExactTarget\StructType\ListAttribute $baseAttribute
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public function setBaseAttribute(\App\Library\ExactTarget\StructType\ListAttribute $baseAttribute = null)
    {
        $this->BaseAttribute = $baseAttribute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ListAttribute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
