<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Keys StructType
 * @subpackage Structs
 */
class Keys extends AbstractStructBase
{
    /**
     * The Key
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $Key;
    /**
     * Constructor method for Keys
     * @uses Keys::setKey()
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $key
     */
    public function __construct(array $key = array())
    {
        $this
            ->setKey($key);
    }
    /**
     * Get Key value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $key
     * @return \App\Library\ExactTarget\StructType\Keys
     */
    public function setKey(array $key = array())
    {
        foreach ($key as $keysKeyItem) {
            // validation for constraint: itemType
            if (!$keysKeyItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The Key property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($keysKeyItem) ? get_class($keysKeyItem) : gettype($keysKeyItem)), __LINE__);
            }
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Add item to Key value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\Keys
     */
    public function addToKey(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The Key property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Key[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Keys
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
