<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JsonWebKey StructType
 * @subpackage Structs
 */
class JsonWebKey extends AbstractStructBase
{
    /**
     * The KeyType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyType;
    /**
     * The KeyModulus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyModulus;
    /**
     * The KeyExponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyExponent;
    /**
     * The KeyAlgorithm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyAlgorithm;
    /**
     * The KeyUse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyUse;
    /**
     * The KeyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyId;
    /**
     * Constructor method for JsonWebKey
     * @uses JsonWebKey::setKeyType()
     * @uses JsonWebKey::setKeyModulus()
     * @uses JsonWebKey::setKeyExponent()
     * @uses JsonWebKey::setKeyAlgorithm()
     * @uses JsonWebKey::setKeyUse()
     * @uses JsonWebKey::setKeyId()
     * @param string $keyType
     * @param string $keyModulus
     * @param string $keyExponent
     * @param string $keyAlgorithm
     * @param string $keyUse
     * @param string $keyId
     */
    public function __construct($keyType = null, $keyModulus = null, $keyExponent = null, $keyAlgorithm = null, $keyUse = null, $keyId = null)
    {
        $this
            ->setKeyType($keyType)
            ->setKeyModulus($keyModulus)
            ->setKeyExponent($keyExponent)
            ->setKeyAlgorithm($keyAlgorithm)
            ->setKeyUse($keyUse)
            ->setKeyId($keyId);
    }
    /**
     * Get KeyType value
     * @return string|null
     */
    public function getKeyType()
    {
        return $this->KeyType;
    }
    /**
     * Set KeyType value
     * @param string $keyType
     * @return \App\Library\ExactTarget\StructType\JsonWebKey
     */
    public function setKeyType($keyType = null)
    {
        // validation for constraint: string
        if (!is_null($keyType) && !is_string($keyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyType)), __LINE__);
        }
        $this->KeyType = $keyType;
        return $this;
    }
    /**
     * Get KeyModulus value
     * @return string|null
     */
    public function getKeyModulus()
    {
        return $this->KeyModulus;
    }
    /**
     * Set KeyModulus value
     * @param string $keyModulus
     * @return \App\Library\ExactTarget\StructType\JsonWebKey
     */
    public function setKeyModulus($keyModulus = null)
    {
        // validation for constraint: string
        if (!is_null($keyModulus) && !is_string($keyModulus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyModulus)), __LINE__);
        }
        $this->KeyModulus = $keyModulus;
        return $this;
    }
    /**
     * Get KeyExponent value
     * @return string|null
     */
    public function getKeyExponent()
    {
        return $this->KeyExponent;
    }
    /**
     * Set KeyExponent value
     * @param string $keyExponent
     * @return \App\Library\ExactTarget\StructType\JsonWebKey
     */
    public function setKeyExponent($keyExponent = null)
    {
        // validation for constraint: string
        if (!is_null($keyExponent) && !is_string($keyExponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyExponent)), __LINE__);
        }
        $this->KeyExponent = $keyExponent;
        return $this;
    }
    /**
     * Get KeyAlgorithm value
     * @return string|null
     */
    public function getKeyAlgorithm()
    {
        return $this->KeyAlgorithm;
    }
    /**
     * Set KeyAlgorithm value
     * @param string $keyAlgorithm
     * @return \App\Library\ExactTarget\StructType\JsonWebKey
     */
    public function setKeyAlgorithm($keyAlgorithm = null)
    {
        // validation for constraint: string
        if (!is_null($keyAlgorithm) && !is_string($keyAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyAlgorithm)), __LINE__);
        }
        $this->KeyAlgorithm = $keyAlgorithm;
        return $this;
    }
    /**
     * Get KeyUse value
     * @return string|null
     */
    public function getKeyUse()
    {
        return $this->KeyUse;
    }
    /**
     * Set KeyUse value
     * @param string $keyUse
     * @return \App\Library\ExactTarget\StructType\JsonWebKey
     */
    public function setKeyUse($keyUse = null)
    {
        // validation for constraint: string
        if (!is_null($keyUse) && !is_string($keyUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyUse)), __LINE__);
        }
        $this->KeyUse = $keyUse;
        return $this;
    }
    /**
     * Get KeyId value
     * @return string|null
     */
    public function getKeyId()
    {
        return $this->KeyId;
    }
    /**
     * Set KeyId value
     * @param string $keyId
     * @return \App\Library\ExactTarget\StructType\JsonWebKey
     */
    public function setKeyId($keyId = null)
    {
        // validation for constraint: string
        if (!is_null($keyId) && !is_string($keyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyId)), __LINE__);
        }
        $this->KeyId = $keyId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\JsonWebKey
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
