<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interactions StructType
 * @subpackage Structs
 */
class Interactions extends AbstractStructBase
{
    /**
     * The Interaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject[]
     */
    public $Interaction;
    /**
     * Constructor method for Interactions
     * @uses Interactions::setInteraction()
     * @param \App\Library\ExactTarget\StructType\APIObject[] $interaction
     */
    public function __construct(array $interaction = array())
    {
        $this
            ->setInteraction($interaction);
    }
    /**
     * Get Interaction value
     * @return \App\Library\ExactTarget\StructType\APIObject[]|null
     */
    public function getInteraction()
    {
        return $this->Interaction;
    }
    /**
     * Set Interaction value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject[] $interaction
     * @return \App\Library\ExactTarget\StructType\Interactions
     */
    public function setInteraction(array $interaction = array())
    {
        foreach ($interaction as $interactionsInteractionItem) {
            // validation for constraint: itemType
            if (!$interactionsInteractionItem instanceof \App\Library\ExactTarget\StructType\APIObject) {
                throw new \InvalidArgumentException(sprintf('The Interaction property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($interactionsInteractionItem) ? get_class($interactionsInteractionItem) : gettype($interactionsInteractionItem)), __LINE__);
            }
        }
        $this->Interaction = $interaction;
        return $this;
    }
    /**
     * Add item to Interaction value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject $item
     * @return \App\Library\ExactTarget\StructType\Interactions
     */
    public function addToInteraction(\App\Library\ExactTarget\StructType\APIObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIObject) {
            throw new \InvalidArgumentException(sprintf('The Interaction property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Interaction[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Interactions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
