<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntegrationProfileDefinition StructType
 * @subpackage Structs
 */
class IntegrationProfileDefinition extends APIObject
{
    /**
     * The ProfileID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProfileID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Description;
    /**
     * The ExternalSystemType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExternalSystemType;
    /**
     * Constructor method for IntegrationProfileDefinition
     * @uses IntegrationProfileDefinition::setProfileID()
     * @uses IntegrationProfileDefinition::setName()
     * @uses IntegrationProfileDefinition::setDescription()
     * @uses IntegrationProfileDefinition::setExternalSystemType()
     * @param string $profileID
     * @param string $name
     * @param string $description
     * @param int $externalSystemType
     */
    public function __construct($profileID = null, $name = null, $description = null, $externalSystemType = null)
    {
        $this
            ->setProfileID($profileID)
            ->setName($name)
            ->setDescription($description)
            ->setExternalSystemType($externalSystemType);
    }
    /**
     * Get ProfileID value
     * @return string
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param string $profileID
     * @return \App\Library\ExactTarget\StructType\IntegrationProfileDefinition
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: string
        if (!is_null($profileID) && !is_string($profileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\IntegrationProfileDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\IntegrationProfileDefinition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ExternalSystemType value
     * @return int
     */
    public function getExternalSystemType()
    {
        return $this->ExternalSystemType;
    }
    /**
     * Set ExternalSystemType value
     * @param int $externalSystemType
     * @return \App\Library\ExactTarget\StructType\IntegrationProfileDefinition
     */
    public function setExternalSystemType($externalSystemType = null)
    {
        // validation for constraint: int
        if (!is_null($externalSystemType) && !is_numeric($externalSystemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($externalSystemType)), __LINE__);
        }
        $this->ExternalSystemType = $externalSystemType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\IntegrationProfileDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
