<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntegrationProfile StructType
 * @subpackage Structs
 */
class IntegrationProfile extends APIObject
{
    /**
     * The ProfileID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProfileID;
    /**
     * The SubscriberKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SubscriberKey;
    /**
     * The ExternalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExternalID;
    /**
     * The ExternalType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExternalType;
    /**
     * Constructor method for IntegrationProfile
     * @uses IntegrationProfile::setProfileID()
     * @uses IntegrationProfile::setSubscriberKey()
     * @uses IntegrationProfile::setExternalID()
     * @uses IntegrationProfile::setExternalType()
     * @param string $profileID
     * @param string $subscriberKey
     * @param string $externalID
     * @param string $externalType
     */
    public function __construct($profileID = null, $subscriberKey = null, $externalID = null, $externalType = null)
    {
        $this
            ->setProfileID($profileID)
            ->setSubscriberKey($subscriberKey)
            ->setExternalID($externalID)
            ->setExternalType($externalType);
    }
    /**
     * Get ProfileID value
     * @return string
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param string $profileID
     * @return \App\Library\ExactTarget\StructType\IntegrationProfile
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: string
        if (!is_null($profileID) && !is_string($profileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get SubscriberKey value
     * @return string
     */
    public function getSubscriberKey()
    {
        return $this->SubscriberKey;
    }
    /**
     * Set SubscriberKey value
     * @param string $subscriberKey
     * @return \App\Library\ExactTarget\StructType\IntegrationProfile
     */
    public function setSubscriberKey($subscriberKey = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberKey) && !is_string($subscriberKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberKey)), __LINE__);
        }
        $this->SubscriberKey = $subscriberKey;
        return $this;
    }
    /**
     * Get ExternalID value
     * @return string
     */
    public function getExternalID()
    {
        return $this->ExternalID;
    }
    /**
     * Set ExternalID value
     * @param string $externalID
     * @return \App\Library\ExactTarget\StructType\IntegrationProfile
     */
    public function setExternalID($externalID = null)
    {
        // validation for constraint: string
        if (!is_null($externalID) && !is_string($externalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalID)), __LINE__);
        }
        $this->ExternalID = $externalID;
        return $this;
    }
    /**
     * Get ExternalType value
     * @return string
     */
    public function getExternalType()
    {
        return $this->ExternalType;
    }
    /**
     * Set ExternalType value
     * @param string $externalType
     * @return \App\Library\ExactTarget\StructType\IntegrationProfile
     */
    public function setExternalType($externalType = null)
    {
        // validation for constraint: string
        if (!is_null($externalType) && !is_string($externalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalType)), __LINE__);
        }
        $this->ExternalType = $externalType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\IntegrationProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
