<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportDefinitionColumnBasedAction StructType
 * @subpackage Structs
 */
class ImportDefinitionColumnBasedAction extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * Constructor method for ImportDefinitionColumnBasedAction
     * @uses ImportDefinitionColumnBasedAction::setValue()
     * @uses ImportDefinitionColumnBasedAction::setAction()
     * @param string $value
     * @param string $action
     */
    public function __construct($value = null, $action = null)
    {
        $this
            ->setValue($value)
            ->setAction($action);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \App\Library\ExactTarget\StructType\ImportDefinitionColumnBasedAction
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \App\Library\ExactTarget\EnumType\ImportDefinitionColumnBasedActionType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\ImportDefinitionColumnBasedActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \App\Library\ExactTarget\StructType\ImportDefinitionColumnBasedAction
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\ImportDefinitionColumnBasedActionType::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \App\Library\ExactTarget\EnumType\ImportDefinitionColumnBasedActionType::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ImportDefinitionColumnBasedAction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
