<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportDefinition StructType
 * @subpackage Structs
 */
class ImportDefinition extends InteractionDefinition
{
    /**
     * The AllowErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AllowErrors;
    /**
     * The DestinationObject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject
     */
    public $DestinationObject;
    /**
     * The FieldMappingType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldMappingType;
    /**
     * The FieldMaps
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\FieldMaps
     */
    public $FieldMaps;
    /**
     * The FileSpec
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileSpec;
    /**
     * The FileType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileType;
    /**
     * The Notification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AsyncResponse
     */
    public $Notification;
    /**
     * The RetrieveFileTransferLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\FileTransferLocation
     */
    public $RetrieveFileTransferLocation;
    /**
     * The SubscriberImportType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubscriberImportType;
    /**
     * The UpdateType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpdateType;
    /**
     * The MaxFileAge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MaxFileAge;
    /**
     * The MaxFileAgeScheduleOffset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MaxFileAgeScheduleOffset;
    /**
     * The MaxImportFrequency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MaxImportFrequency;
    /**
     * The Delimiter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Delimiter;
    /**
     * The HeaderLines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $HeaderLines;
    /**
     * The AutoGenerateDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ImportDefinitionAutoGenerateDestination
     */
    public $AutoGenerateDestination;
    /**
     * The ControlColumn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ControlColumn;
    /**
     * The ControlColumnDefaultAction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ControlColumnDefaultAction;
    /**
     * The ControlColumnActions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ControlColumnActions
     */
    public $ControlColumnActions;
    /**
     * The EndOfLineRepresentation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndOfLineRepresentation;
    /**
     * The NullRepresentation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NullRepresentation;
    /**
     * The StandardQuotedStrings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $StandardQuotedStrings;
    /**
     * The Filter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter;
    /**
     * The DateFormattingLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Locale
     */
    public $DateFormattingLocale;
    /**
     * The DeleteFile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DeleteFile;
    /**
     * The SourceObject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject
     */
    public $SourceObject;
    /**
     * The DestinationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DestinationType;
    /**
     * The SubscriptionDefinitionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubscriptionDefinitionId;
    /**
     * The EncodingCodePage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $EncodingCodePage;
    /**
     * The SmsMemberSharedShortCodeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SmsMemberSharedShortCodeId;
    /**
     * Constructor method for ImportDefinition
     * @uses ImportDefinition::setAllowErrors()
     * @uses ImportDefinition::setDestinationObject()
     * @uses ImportDefinition::setFieldMappingType()
     * @uses ImportDefinition::setFieldMaps()
     * @uses ImportDefinition::setFileSpec()
     * @uses ImportDefinition::setFileType()
     * @uses ImportDefinition::setNotification()
     * @uses ImportDefinition::setRetrieveFileTransferLocation()
     * @uses ImportDefinition::setSubscriberImportType()
     * @uses ImportDefinition::setUpdateType()
     * @uses ImportDefinition::setMaxFileAge()
     * @uses ImportDefinition::setMaxFileAgeScheduleOffset()
     * @uses ImportDefinition::setMaxImportFrequency()
     * @uses ImportDefinition::setDelimiter()
     * @uses ImportDefinition::setHeaderLines()
     * @uses ImportDefinition::setAutoGenerateDestination()
     * @uses ImportDefinition::setControlColumn()
     * @uses ImportDefinition::setControlColumnDefaultAction()
     * @uses ImportDefinition::setControlColumnActions()
     * @uses ImportDefinition::setEndOfLineRepresentation()
     * @uses ImportDefinition::setNullRepresentation()
     * @uses ImportDefinition::setStandardQuotedStrings()
     * @uses ImportDefinition::setFilter()
     * @uses ImportDefinition::setDateFormattingLocale()
     * @uses ImportDefinition::setDeleteFile()
     * @uses ImportDefinition::setSourceObject()
     * @uses ImportDefinition::setDestinationType()
     * @uses ImportDefinition::setSubscriptionDefinitionId()
     * @uses ImportDefinition::setEncodingCodePage()
     * @uses ImportDefinition::setSmsMemberSharedShortCodeId()
     * @param bool $allowErrors
     * @param \App\Library\ExactTarget\StructType\APIObject $destinationObject
     * @param string $fieldMappingType
     * @param \App\Library\ExactTarget\StructType\FieldMaps $fieldMaps
     * @param string $fileSpec
     * @param string $fileType
     * @param \App\Library\ExactTarget\StructType\AsyncResponse $notification
     * @param \App\Library\ExactTarget\StructType\FileTransferLocation $retrieveFileTransferLocation
     * @param string $subscriberImportType
     * @param string $updateType
     * @param int $maxFileAge
     * @param int $maxFileAgeScheduleOffset
     * @param int $maxImportFrequency
     * @param string $delimiter
     * @param int $headerLines
     * @param \App\Library\ExactTarget\StructType\ImportDefinitionAutoGenerateDestination $autoGenerateDestination
     * @param string $controlColumn
     * @param string $controlColumnDefaultAction
     * @param \App\Library\ExactTarget\StructType\ControlColumnActions $controlColumnActions
     * @param string $endOfLineRepresentation
     * @param string $nullRepresentation
     * @param bool $standardQuotedStrings
     * @param string $filter
     * @param \App\Library\ExactTarget\StructType\Locale $dateFormattingLocale
     * @param bool $deleteFile
     * @param \App\Library\ExactTarget\StructType\APIObject $sourceObject
     * @param int $destinationType
     * @param string $subscriptionDefinitionId
     * @param int $encodingCodePage
     * @param string $smsMemberSharedShortCodeId
     */
    public function __construct($allowErrors = null, \App\Library\ExactTarget\StructType\APIObject $destinationObject = null, $fieldMappingType = null, \App\Library\ExactTarget\StructType\FieldMaps $fieldMaps = null, $fileSpec = null, $fileType = null, \App\Library\ExactTarget\StructType\AsyncResponse $notification = null, \App\Library\ExactTarget\StructType\FileTransferLocation $retrieveFileTransferLocation = null, $subscriberImportType = null, $updateType = null, $maxFileAge = null, $maxFileAgeScheduleOffset = null, $maxImportFrequency = null, $delimiter = null, $headerLines = null, \App\Library\ExactTarget\StructType\ImportDefinitionAutoGenerateDestination $autoGenerateDestination = null, $controlColumn = null, $controlColumnDefaultAction = null, \App\Library\ExactTarget\StructType\ControlColumnActions $controlColumnActions = null, $endOfLineRepresentation = null, $nullRepresentation = null, $standardQuotedStrings = null, $filter = null, \App\Library\ExactTarget\StructType\Locale $dateFormattingLocale = null, $deleteFile = null, \App\Library\ExactTarget\StructType\APIObject $sourceObject = null, $destinationType = null, $subscriptionDefinitionId = null, $encodingCodePage = null, $smsMemberSharedShortCodeId = null)
    {
        $this
            ->setAllowErrors($allowErrors)
            ->setDestinationObject($destinationObject)
            ->setFieldMappingType($fieldMappingType)
            ->setFieldMaps($fieldMaps)
            ->setFileSpec($fileSpec)
            ->setFileType($fileType)
            ->setNotification($notification)
            ->setRetrieveFileTransferLocation($retrieveFileTransferLocation)
            ->setSubscriberImportType($subscriberImportType)
            ->setUpdateType($updateType)
            ->setMaxFileAge($maxFileAge)
            ->setMaxFileAgeScheduleOffset($maxFileAgeScheduleOffset)
            ->setMaxImportFrequency($maxImportFrequency)
            ->setDelimiter($delimiter)
            ->setHeaderLines($headerLines)
            ->setAutoGenerateDestination($autoGenerateDestination)
            ->setControlColumn($controlColumn)
            ->setControlColumnDefaultAction($controlColumnDefaultAction)
            ->setControlColumnActions($controlColumnActions)
            ->setEndOfLineRepresentation($endOfLineRepresentation)
            ->setNullRepresentation($nullRepresentation)
            ->setStandardQuotedStrings($standardQuotedStrings)
            ->setFilter($filter)
            ->setDateFormattingLocale($dateFormattingLocale)
            ->setDeleteFile($deleteFile)
            ->setSourceObject($sourceObject)
            ->setDestinationType($destinationType)
            ->setSubscriptionDefinitionId($subscriptionDefinitionId)
            ->setEncodingCodePage($encodingCodePage)
            ->setSmsMemberSharedShortCodeId($smsMemberSharedShortCodeId);
    }
    /**
     * Get AllowErrors value
     * @return bool|null
     */
    public function getAllowErrors()
    {
        return $this->AllowErrors;
    }
    /**
     * Set AllowErrors value
     * @param bool $allowErrors
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setAllowErrors($allowErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowErrors) && !is_bool($allowErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowErrors)), __LINE__);
        }
        $this->AllowErrors = $allowErrors;
        return $this;
    }
    /**
     * Get DestinationObject value
     * @return \App\Library\ExactTarget\StructType\APIObject|null
     */
    public function getDestinationObject()
    {
        return $this->DestinationObject;
    }
    /**
     * Set DestinationObject value
     * @param \App\Library\ExactTarget\StructType\APIObject $destinationObject
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setDestinationObject(\App\Library\ExactTarget\StructType\APIObject $destinationObject = null)
    {
        $this->DestinationObject = $destinationObject;
        return $this;
    }
    /**
     * Get FieldMappingType value
     * @return string|null
     */
    public function getFieldMappingType()
    {
        return $this->FieldMappingType;
    }
    /**
     * Set FieldMappingType value
     * @uses \App\Library\ExactTarget\EnumType\ImportDefinitionFieldMappingType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\ImportDefinitionFieldMappingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fieldMappingType
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setFieldMappingType($fieldMappingType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\ImportDefinitionFieldMappingType::valueIsValid($fieldMappingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fieldMappingType, implode(', ', \App\Library\ExactTarget\EnumType\ImportDefinitionFieldMappingType::getValidValues())), __LINE__);
        }
        $this->FieldMappingType = $fieldMappingType;
        return $this;
    }
    /**
     * Get FieldMaps value
     * @return \App\Library\ExactTarget\StructType\FieldMaps|null
     */
    public function getFieldMaps()
    {
        return $this->FieldMaps;
    }
    /**
     * Set FieldMaps value
     * @param \App\Library\ExactTarget\StructType\FieldMaps $fieldMaps
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setFieldMaps(\App\Library\ExactTarget\StructType\FieldMaps $fieldMaps = null)
    {
        $this->FieldMaps = $fieldMaps;
        return $this;
    }
    /**
     * Get FileSpec value
     * @return string|null
     */
    public function getFileSpec()
    {
        return $this->FileSpec;
    }
    /**
     * Set FileSpec value
     * @param string $fileSpec
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setFileSpec($fileSpec = null)
    {
        // validation for constraint: string
        if (!is_null($fileSpec) && !is_string($fileSpec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileSpec)), __LINE__);
        }
        $this->FileSpec = $fileSpec;
        return $this;
    }
    /**
     * Get FileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->FileType;
    }
    /**
     * Set FileType value
     * @uses \App\Library\ExactTarget\EnumType\FileType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\FileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fileType
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\FileType::valueIsValid($fileType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fileType, implode(', ', \App\Library\ExactTarget\EnumType\FileType::getValidValues())), __LINE__);
        }
        $this->FileType = $fileType;
        return $this;
    }
    /**
     * Get Notification value
     * @return \App\Library\ExactTarget\StructType\AsyncResponse|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \App\Library\ExactTarget\StructType\AsyncResponse $notification
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setNotification(\App\Library\ExactTarget\StructType\AsyncResponse $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get RetrieveFileTransferLocation value
     * @return \App\Library\ExactTarget\StructType\FileTransferLocation|null
     */
    public function getRetrieveFileTransferLocation()
    {
        return $this->RetrieveFileTransferLocation;
    }
    /**
     * Set RetrieveFileTransferLocation value
     * @param \App\Library\ExactTarget\StructType\FileTransferLocation $retrieveFileTransferLocation
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setRetrieveFileTransferLocation(\App\Library\ExactTarget\StructType\FileTransferLocation $retrieveFileTransferLocation = null)
    {
        $this->RetrieveFileTransferLocation = $retrieveFileTransferLocation;
        return $this;
    }
    /**
     * Get SubscriberImportType value
     * @return string|null
     */
    public function getSubscriberImportType()
    {
        return $this->SubscriberImportType;
    }
    /**
     * Set SubscriberImportType value
     * @uses \App\Library\ExactTarget\EnumType\ImportDefinitionSubscriberImportType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\ImportDefinitionSubscriberImportType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberImportType
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setSubscriberImportType($subscriberImportType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\ImportDefinitionSubscriberImportType::valueIsValid($subscriberImportType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subscriberImportType, implode(', ', \App\Library\ExactTarget\EnumType\ImportDefinitionSubscriberImportType::getValidValues())), __LINE__);
        }
        $this->SubscriberImportType = $subscriberImportType;
        return $this;
    }
    /**
     * Get UpdateType value
     * @return string|null
     */
    public function getUpdateType()
    {
        return $this->UpdateType;
    }
    /**
     * Set UpdateType value
     * @uses \App\Library\ExactTarget\EnumType\ImportDefinitionUpdateType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\ImportDefinitionUpdateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $updateType
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setUpdateType($updateType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\ImportDefinitionUpdateType::valueIsValid($updateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $updateType, implode(', ', \App\Library\ExactTarget\EnumType\ImportDefinitionUpdateType::getValidValues())), __LINE__);
        }
        $this->UpdateType = $updateType;
        return $this;
    }
    /**
     * Get MaxFileAge value
     * @return int|null
     */
    public function getMaxFileAge()
    {
        return $this->MaxFileAge;
    }
    /**
     * Set MaxFileAge value
     * @param int $maxFileAge
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setMaxFileAge($maxFileAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxFileAge) && !is_numeric($maxFileAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxFileAge)), __LINE__);
        }
        $this->MaxFileAge = $maxFileAge;
        return $this;
    }
    /**
     * Get MaxFileAgeScheduleOffset value
     * @return int|null
     */
    public function getMaxFileAgeScheduleOffset()
    {
        return $this->MaxFileAgeScheduleOffset;
    }
    /**
     * Set MaxFileAgeScheduleOffset value
     * @param int $maxFileAgeScheduleOffset
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setMaxFileAgeScheduleOffset($maxFileAgeScheduleOffset = null)
    {
        // validation for constraint: int
        if (!is_null($maxFileAgeScheduleOffset) && !is_numeric($maxFileAgeScheduleOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxFileAgeScheduleOffset)), __LINE__);
        }
        $this->MaxFileAgeScheduleOffset = $maxFileAgeScheduleOffset;
        return $this;
    }
    /**
     * Get MaxImportFrequency value
     * @return int|null
     */
    public function getMaxImportFrequency()
    {
        return $this->MaxImportFrequency;
    }
    /**
     * Set MaxImportFrequency value
     * @param int $maxImportFrequency
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setMaxImportFrequency($maxImportFrequency = null)
    {
        // validation for constraint: int
        if (!is_null($maxImportFrequency) && !is_numeric($maxImportFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxImportFrequency)), __LINE__);
        }
        $this->MaxImportFrequency = $maxImportFrequency;
        return $this;
    }
    /**
     * Get Delimiter value
     * @return string|null
     */
    public function getDelimiter()
    {
        return $this->Delimiter;
    }
    /**
     * Set Delimiter value
     * @param string $delimiter
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setDelimiter($delimiter = null)
    {
        // validation for constraint: string
        if (!is_null($delimiter) && !is_string($delimiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delimiter)), __LINE__);
        }
        $this->Delimiter = $delimiter;
        return $this;
    }
    /**
     * Get HeaderLines value
     * @return int|null
     */
    public function getHeaderLines()
    {
        return $this->HeaderLines;
    }
    /**
     * Set HeaderLines value
     * @param int $headerLines
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setHeaderLines($headerLines = null)
    {
        // validation for constraint: int
        if (!is_null($headerLines) && !is_numeric($headerLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($headerLines)), __LINE__);
        }
        $this->HeaderLines = $headerLines;
        return $this;
    }
    /**
     * Get AutoGenerateDestination value
     * @return \App\Library\ExactTarget\StructType\ImportDefinitionAutoGenerateDestination|null
     */
    public function getAutoGenerateDestination()
    {
        return $this->AutoGenerateDestination;
    }
    /**
     * Set AutoGenerateDestination value
     * @param \App\Library\ExactTarget\StructType\ImportDefinitionAutoGenerateDestination $autoGenerateDestination
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setAutoGenerateDestination(\App\Library\ExactTarget\StructType\ImportDefinitionAutoGenerateDestination $autoGenerateDestination = null)
    {
        $this->AutoGenerateDestination = $autoGenerateDestination;
        return $this;
    }
    /**
     * Get ControlColumn value
     * @return string|null
     */
    public function getControlColumn()
    {
        return $this->ControlColumn;
    }
    /**
     * Set ControlColumn value
     * @param string $controlColumn
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setControlColumn($controlColumn = null)
    {
        // validation for constraint: string
        if (!is_null($controlColumn) && !is_string($controlColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($controlColumn)), __LINE__);
        }
        $this->ControlColumn = $controlColumn;
        return $this;
    }
    /**
     * Get ControlColumnDefaultAction value
     * @return string|null
     */
    public function getControlColumnDefaultAction()
    {
        return $this->ControlColumnDefaultAction;
    }
    /**
     * Set ControlColumnDefaultAction value
     * @uses \App\Library\ExactTarget\EnumType\ImportDefinitionColumnBasedActionType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\ImportDefinitionColumnBasedActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $controlColumnDefaultAction
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setControlColumnDefaultAction($controlColumnDefaultAction = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\ImportDefinitionColumnBasedActionType::valueIsValid($controlColumnDefaultAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $controlColumnDefaultAction, implode(', ', \App\Library\ExactTarget\EnumType\ImportDefinitionColumnBasedActionType::getValidValues())), __LINE__);
        }
        $this->ControlColumnDefaultAction = $controlColumnDefaultAction;
        return $this;
    }
    /**
     * Get ControlColumnActions value
     * @return \App\Library\ExactTarget\StructType\ControlColumnActions|null
     */
    public function getControlColumnActions()
    {
        return $this->ControlColumnActions;
    }
    /**
     * Set ControlColumnActions value
     * @param \App\Library\ExactTarget\StructType\ControlColumnActions $controlColumnActions
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setControlColumnActions(\App\Library\ExactTarget\StructType\ControlColumnActions $controlColumnActions = null)
    {
        $this->ControlColumnActions = $controlColumnActions;
        return $this;
    }
    /**
     * Get EndOfLineRepresentation value
     * @return string|null
     */
    public function getEndOfLineRepresentation()
    {
        return $this->EndOfLineRepresentation;
    }
    /**
     * Set EndOfLineRepresentation value
     * @param string $endOfLineRepresentation
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setEndOfLineRepresentation($endOfLineRepresentation = null)
    {
        // validation for constraint: string
        if (!is_null($endOfLineRepresentation) && !is_string($endOfLineRepresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endOfLineRepresentation)), __LINE__);
        }
        $this->EndOfLineRepresentation = $endOfLineRepresentation;
        return $this;
    }
    /**
     * Get NullRepresentation value
     * @return string|null
     */
    public function getNullRepresentation()
    {
        return $this->NullRepresentation;
    }
    /**
     * Set NullRepresentation value
     * @param string $nullRepresentation
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setNullRepresentation($nullRepresentation = null)
    {
        // validation for constraint: string
        if (!is_null($nullRepresentation) && !is_string($nullRepresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nullRepresentation)), __LINE__);
        }
        $this->NullRepresentation = $nullRepresentation;
        return $this;
    }
    /**
     * Get StandardQuotedStrings value
     * @return bool|null
     */
    public function getStandardQuotedStrings()
    {
        return $this->StandardQuotedStrings;
    }
    /**
     * Set StandardQuotedStrings value
     * @param bool $standardQuotedStrings
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setStandardQuotedStrings($standardQuotedStrings = null)
    {
        // validation for constraint: boolean
        if (!is_null($standardQuotedStrings) && !is_bool($standardQuotedStrings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($standardQuotedStrings)), __LINE__);
        }
        $this->StandardQuotedStrings = $standardQuotedStrings;
        return $this;
    }
    /**
     * Get Filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param string $filter
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filter)), __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Get DateFormattingLocale value
     * @return \App\Library\ExactTarget\StructType\Locale|null
     */
    public function getDateFormattingLocale()
    {
        return $this->DateFormattingLocale;
    }
    /**
     * Set DateFormattingLocale value
     * @param \App\Library\ExactTarget\StructType\Locale $dateFormattingLocale
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setDateFormattingLocale(\App\Library\ExactTarget\StructType\Locale $dateFormattingLocale = null)
    {
        $this->DateFormattingLocale = $dateFormattingLocale;
        return $this;
    }
    /**
     * Get DeleteFile value
     * @return bool|null
     */
    public function getDeleteFile()
    {
        return $this->DeleteFile;
    }
    /**
     * Set DeleteFile value
     * @param bool $deleteFile
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setDeleteFile($deleteFile = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleteFile) && !is_bool($deleteFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deleteFile)), __LINE__);
        }
        $this->DeleteFile = $deleteFile;
        return $this;
    }
    /**
     * Get SourceObject value
     * @return \App\Library\ExactTarget\StructType\APIObject|null
     */
    public function getSourceObject()
    {
        return $this->SourceObject;
    }
    /**
     * Set SourceObject value
     * @param \App\Library\ExactTarget\StructType\APIObject $sourceObject
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setSourceObject(\App\Library\ExactTarget\StructType\APIObject $sourceObject = null)
    {
        $this->SourceObject = $sourceObject;
        return $this;
    }
    /**
     * Get DestinationType value
     * @return int|null
     */
    public function getDestinationType()
    {
        return $this->DestinationType;
    }
    /**
     * Set DestinationType value
     * @param int $destinationType
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setDestinationType($destinationType = null)
    {
        // validation for constraint: int
        if (!is_null($destinationType) && !is_numeric($destinationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationType)), __LINE__);
        }
        $this->DestinationType = $destinationType;
        return $this;
    }
    /**
     * Get SubscriptionDefinitionId value
     * @return string|null
     */
    public function getSubscriptionDefinitionId()
    {
        return $this->SubscriptionDefinitionId;
    }
    /**
     * Set SubscriptionDefinitionId value
     * @param string $subscriptionDefinitionId
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setSubscriptionDefinitionId($subscriptionDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionDefinitionId) && !is_string($subscriptionDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriptionDefinitionId)), __LINE__);
        }
        $this->SubscriptionDefinitionId = $subscriptionDefinitionId;
        return $this;
    }
    /**
     * Get EncodingCodePage value
     * @return int|null
     */
    public function getEncodingCodePage()
    {
        return $this->EncodingCodePage;
    }
    /**
     * Set EncodingCodePage value
     * @param int $encodingCodePage
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setEncodingCodePage($encodingCodePage = null)
    {
        // validation for constraint: int
        if (!is_null($encodingCodePage) && !is_numeric($encodingCodePage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($encodingCodePage)), __LINE__);
        }
        $this->EncodingCodePage = $encodingCodePage;
        return $this;
    }
    /**
     * Get SmsMemberSharedShortCodeId value
     * @return string|null
     */
    public function getSmsMemberSharedShortCodeId()
    {
        return $this->SmsMemberSharedShortCodeId;
    }
    /**
     * Set SmsMemberSharedShortCodeId value
     * @param string $smsMemberSharedShortCodeId
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public function setSmsMemberSharedShortCodeId($smsMemberSharedShortCodeId = null)
    {
        // validation for constraint: string
        if (!is_null($smsMemberSharedShortCodeId) && !is_string($smsMemberSharedShortCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($smsMemberSharedShortCodeId)), __LINE__);
        }
        $this->SmsMemberSharedShortCodeId = $smsMemberSharedShortCodeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ImportDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
