<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HourlyRecurrence StructType
 * Meta informations extracted from the WSDL
 * - type: tns:HourlyRecurrence
 * @subpackage Structs
 */
class HourlyRecurrence extends Recurrence
{
    /**
     * The HourlyRecurrencePatternType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HourlyRecurrencePatternType;
    /**
     * The HourInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $HourInterval;
    /**
     * Constructor method for HourlyRecurrence
     * @uses HourlyRecurrence::setHourlyRecurrencePatternType()
     * @uses HourlyRecurrence::setHourInterval()
     * @param string $hourlyRecurrencePatternType
     * @param int $hourInterval
     */
    public function __construct($hourlyRecurrencePatternType = null, $hourInterval = null)
    {
        $this
            ->setHourlyRecurrencePatternType($hourlyRecurrencePatternType)
            ->setHourInterval($hourInterval);
    }
    /**
     * Get HourlyRecurrencePatternType value
     * @return string|null
     */
    public function getHourlyRecurrencePatternType()
    {
        return $this->HourlyRecurrencePatternType;
    }
    /**
     * Set HourlyRecurrencePatternType value
     * @uses \App\Library\ExactTarget\EnumType\HourlyRecurrencePatternTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\HourlyRecurrencePatternTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hourlyRecurrencePatternType
     * @return \App\Library\ExactTarget\StructType\HourlyRecurrence
     */
    public function setHourlyRecurrencePatternType($hourlyRecurrencePatternType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\HourlyRecurrencePatternTypeEnum::valueIsValid($hourlyRecurrencePatternType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hourlyRecurrencePatternType, implode(', ', \App\Library\ExactTarget\EnumType\HourlyRecurrencePatternTypeEnum::getValidValues())), __LINE__);
        }
        $this->HourlyRecurrencePatternType = $hourlyRecurrencePatternType;
        return $this;
    }
    /**
     * Get HourInterval value
     * @return int|null
     */
    public function getHourInterval()
    {
        return $this->HourInterval;
    }
    /**
     * Set HourInterval value
     * @param int $hourInterval
     * @return \App\Library\ExactTarget\StructType\HourlyRecurrence
     */
    public function setHourInterval($hourInterval = null)
    {
        // validation for constraint: int
        if (!is_null($hourInterval) && !is_numeric($hourInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hourInterval)), __LINE__);
        }
        $this->HourInterval = $hourInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\HourlyRecurrence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
