<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HiveQueryDefinition StructType
 * @subpackage Structs
 */
class HiveQueryDefinition extends InteractionDefinition
{
    /**
     * The QueryDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QueryDefinition;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CategoryID;
    /**
     * Constructor method for HiveQueryDefinition
     * @uses HiveQueryDefinition::setQueryDefinition()
     * @uses HiveQueryDefinition::setStatus()
     * @uses HiveQueryDefinition::setCategoryID()
     * @param string $queryDefinition
     * @param string $status
     * @param int $categoryID
     */
    public function __construct($queryDefinition = null, $status = null, $categoryID = null)
    {
        $this
            ->setQueryDefinition($queryDefinition)
            ->setStatus($status)
            ->setCategoryID($categoryID);
    }
    /**
     * Get QueryDefinition value
     * @return string|null
     */
    public function getQueryDefinition()
    {
        return $this->QueryDefinition;
    }
    /**
     * Set QueryDefinition value
     * @param string $queryDefinition
     * @return \App\Library\ExactTarget\StructType\HiveQueryDefinition
     */
    public function setQueryDefinition($queryDefinition = null)
    {
        // validation for constraint: string
        if (!is_null($queryDefinition) && !is_string($queryDefinition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryDefinition)), __LINE__);
        }
        $this->QueryDefinition = $queryDefinition;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\HiveQueryDefinition
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \App\Library\ExactTarget\StructType\HiveQueryDefinition
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\HiveQueryDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
