<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpMOKeyword StructType
 * @subpackage Structs
 */
class HelpMOKeyword extends BaseMOKeyword
{
    /**
     * The FriendlyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FriendlyName;
    /**
     * The DefaultHelpMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultHelpMessage;
    /**
     * The MenuText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MenuText;
    /**
     * The MoreChoicesPrompt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MoreChoicesPrompt;
    /**
     * Constructor method for HelpMOKeyword
     * @uses HelpMOKeyword::setFriendlyName()
     * @uses HelpMOKeyword::setDefaultHelpMessage()
     * @uses HelpMOKeyword::setMenuText()
     * @uses HelpMOKeyword::setMoreChoicesPrompt()
     * @param string $friendlyName
     * @param string $defaultHelpMessage
     * @param string $menuText
     * @param string $moreChoicesPrompt
     */
    public function __construct($friendlyName = null, $defaultHelpMessage = null, $menuText = null, $moreChoicesPrompt = null)
    {
        $this
            ->setFriendlyName($friendlyName)
            ->setDefaultHelpMessage($defaultHelpMessage)
            ->setMenuText($menuText)
            ->setMoreChoicesPrompt($moreChoicesPrompt);
    }
    /**
     * Get FriendlyName value
     * @return string|null
     */
    public function getFriendlyName()
    {
        return $this->FriendlyName;
    }
    /**
     * Set FriendlyName value
     * @param string $friendlyName
     * @return \App\Library\ExactTarget\StructType\HelpMOKeyword
     */
    public function setFriendlyName($friendlyName = null)
    {
        // validation for constraint: string
        if (!is_null($friendlyName) && !is_string($friendlyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($friendlyName)), __LINE__);
        }
        $this->FriendlyName = $friendlyName;
        return $this;
    }
    /**
     * Get DefaultHelpMessage value
     * @return string|null
     */
    public function getDefaultHelpMessage()
    {
        return $this->DefaultHelpMessage;
    }
    /**
     * Set DefaultHelpMessage value
     * @param string $defaultHelpMessage
     * @return \App\Library\ExactTarget\StructType\HelpMOKeyword
     */
    public function setDefaultHelpMessage($defaultHelpMessage = null)
    {
        // validation for constraint: string
        if (!is_null($defaultHelpMessage) && !is_string($defaultHelpMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultHelpMessage)), __LINE__);
        }
        $this->DefaultHelpMessage = $defaultHelpMessage;
        return $this;
    }
    /**
     * Get MenuText value
     * @return string|null
     */
    public function getMenuText()
    {
        return $this->MenuText;
    }
    /**
     * Set MenuText value
     * @param string $menuText
     * @return \App\Library\ExactTarget\StructType\HelpMOKeyword
     */
    public function setMenuText($menuText = null)
    {
        // validation for constraint: string
        if (!is_null($menuText) && !is_string($menuText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($menuText)), __LINE__);
        }
        $this->MenuText = $menuText;
        return $this;
    }
    /**
     * Get MoreChoicesPrompt value
     * @return string|null
     */
    public function getMoreChoicesPrompt()
    {
        return $this->MoreChoicesPrompt;
    }
    /**
     * Set MoreChoicesPrompt value
     * @param string $moreChoicesPrompt
     * @return \App\Library\ExactTarget\StructType\HelpMOKeyword
     */
    public function setMoreChoicesPrompt($moreChoicesPrompt = null)
    {
        // validation for constraint: string
        if (!is_null($moreChoicesPrompt) && !is_string($moreChoicesPrompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moreChoicesPrompt)), __LINE__);
        }
        $this->MoreChoicesPrompt = $moreChoicesPrompt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\HelpMOKeyword
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
