<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Group StructType
 * Meta informations extracted from the WSDL
 * - type: tns:Group
 * @subpackage Structs
 */
class Group extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Category;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Subscribers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Subscriber[]
     */
    public $Subscribers;
    /**
     * Constructor method for Group
     * @uses Group::setName()
     * @uses Group::setCategory()
     * @uses Group::setDescription()
     * @uses Group::setSubscribers()
     * @param string $name
     * @param int $category
     * @param string $description
     * @param \App\Library\ExactTarget\StructType\Subscriber[] $subscribers
     */
    public function __construct($name = null, $category = null, $description = null, array $subscribers = array())
    {
        $this
            ->setName($name)
            ->setCategory($category)
            ->setDescription($description)
            ->setSubscribers($subscribers);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\Group
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Category value
     * @return int|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param int $category
     * @return \App\Library\ExactTarget\StructType\Group
     */
    public function setCategory($category = null)
    {
        // validation for constraint: int
        if (!is_null($category) && !is_numeric($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\Group
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Subscribers value
     * @return \App\Library\ExactTarget\StructType\Subscriber[]|null
     */
    public function getSubscribers()
    {
        return $this->Subscribers;
    }
    /**
     * Set Subscribers value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Subscriber[] $subscribers
     * @return \App\Library\ExactTarget\StructType\Group
     */
    public function setSubscribers(array $subscribers = array())
    {
        foreach ($subscribers as $groupSubscribersItem) {
            // validation for constraint: itemType
            if (!$groupSubscribersItem instanceof \App\Library\ExactTarget\StructType\Subscriber) {
                throw new \InvalidArgumentException(sprintf('The Subscribers property can only contain items of \App\Library\ExactTarget\StructType\Subscriber, "%s" given', is_object($groupSubscribersItem) ? get_class($groupSubscribersItem) : gettype($groupSubscribersItem)), __LINE__);
            }
        }
        $this->Subscribers = $subscribers;
        return $this;
    }
    /**
     * Add item to Subscribers value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Subscriber $item
     * @return \App\Library\ExactTarget\StructType\Group
     */
    public function addToSubscribers(\App\Library\ExactTarget\StructType\Subscriber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Subscriber) {
            throw new \InvalidArgumentException(sprintf('The Subscribers property can only contain items of \App\Library\ExactTarget\StructType\Subscriber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Subscribers[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Group
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
