<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterActivity StructType
 * @subpackage Structs
 */
class FilterActivity extends InteractionDefinition
{
    /**
     * The FilterActivityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FilterActivityID;
    /**
     * The FilterDefinitionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FilterDefinitionID;
    /**
     * The DestinationObjectID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationObjectID;
    /**
     * The DestinationTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DestinationTypeID;
    /**
     * The SourceObjectID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceObjectID;
    /**
     * The SourceTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SourceTypeID;
    /**
     * The OwnerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerID;
    /**
     * The StatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusID;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ClientID
     */
    public $CreatedBy;
    /**
     * The ModifiedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ClientID
     */
    public $ModifiedBy;
    /**
     * Constructor method for FilterActivity
     * @uses FilterActivity::setFilterActivityID()
     * @uses FilterActivity::setFilterDefinitionID()
     * @uses FilterActivity::setDestinationObjectID()
     * @uses FilterActivity::setDestinationTypeID()
     * @uses FilterActivity::setSourceObjectID()
     * @uses FilterActivity::setSourceTypeID()
     * @uses FilterActivity::setOwnerID()
     * @uses FilterActivity::setStatusID()
     * @uses FilterActivity::setCreatedBy()
     * @uses FilterActivity::setModifiedBy()
     * @param string $filterActivityID
     * @param string $filterDefinitionID
     * @param string $destinationObjectID
     * @param int $destinationTypeID
     * @param string $sourceObjectID
     * @param int $sourceTypeID
     * @param string $ownerID
     * @param string $statusID
     * @param \App\Library\ExactTarget\StructType\ClientID $createdBy
     * @param \App\Library\ExactTarget\StructType\ClientID $modifiedBy
     */
    public function __construct($filterActivityID = null, $filterDefinitionID = null, $destinationObjectID = null, $destinationTypeID = null, $sourceObjectID = null, $sourceTypeID = null, $ownerID = null, $statusID = null, \App\Library\ExactTarget\StructType\ClientID $createdBy = null, \App\Library\ExactTarget\StructType\ClientID $modifiedBy = null)
    {
        $this
            ->setFilterActivityID($filterActivityID)
            ->setFilterDefinitionID($filterDefinitionID)
            ->setDestinationObjectID($destinationObjectID)
            ->setDestinationTypeID($destinationTypeID)
            ->setSourceObjectID($sourceObjectID)
            ->setSourceTypeID($sourceTypeID)
            ->setOwnerID($ownerID)
            ->setStatusID($statusID)
            ->setCreatedBy($createdBy)
            ->setModifiedBy($modifiedBy);
    }
    /**
     * Get FilterActivityID value
     * @return string|null
     */
    public function getFilterActivityID()
    {
        return $this->FilterActivityID;
    }
    /**
     * Set FilterActivityID value
     * @param string $filterActivityID
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public function setFilterActivityID($filterActivityID = null)
    {
        // validation for constraint: string
        if (!is_null($filterActivityID) && !is_string($filterActivityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filterActivityID)), __LINE__);
        }
        $this->FilterActivityID = $filterActivityID;
        return $this;
    }
    /**
     * Get FilterDefinitionID value
     * @return string|null
     */
    public function getFilterDefinitionID()
    {
        return $this->FilterDefinitionID;
    }
    /**
     * Set FilterDefinitionID value
     * @param string $filterDefinitionID
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public function setFilterDefinitionID($filterDefinitionID = null)
    {
        // validation for constraint: string
        if (!is_null($filterDefinitionID) && !is_string($filterDefinitionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filterDefinitionID)), __LINE__);
        }
        $this->FilterDefinitionID = $filterDefinitionID;
        return $this;
    }
    /**
     * Get DestinationObjectID value
     * @return string|null
     */
    public function getDestinationObjectID()
    {
        return $this->DestinationObjectID;
    }
    /**
     * Set DestinationObjectID value
     * @param string $destinationObjectID
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public function setDestinationObjectID($destinationObjectID = null)
    {
        // validation for constraint: string
        if (!is_null($destinationObjectID) && !is_string($destinationObjectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationObjectID)), __LINE__);
        }
        $this->DestinationObjectID = $destinationObjectID;
        return $this;
    }
    /**
     * Get DestinationTypeID value
     * @return int|null
     */
    public function getDestinationTypeID()
    {
        return $this->DestinationTypeID;
    }
    /**
     * Set DestinationTypeID value
     * @param int $destinationTypeID
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public function setDestinationTypeID($destinationTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($destinationTypeID) && !is_numeric($destinationTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationTypeID)), __LINE__);
        }
        $this->DestinationTypeID = $destinationTypeID;
        return $this;
    }
    /**
     * Get SourceObjectID value
     * @return string|null
     */
    public function getSourceObjectID()
    {
        return $this->SourceObjectID;
    }
    /**
     * Set SourceObjectID value
     * @param string $sourceObjectID
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public function setSourceObjectID($sourceObjectID = null)
    {
        // validation for constraint: string
        if (!is_null($sourceObjectID) && !is_string($sourceObjectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceObjectID)), __LINE__);
        }
        $this->SourceObjectID = $sourceObjectID;
        return $this;
    }
    /**
     * Get SourceTypeID value
     * @return int|null
     */
    public function getSourceTypeID()
    {
        return $this->SourceTypeID;
    }
    /**
     * Set SourceTypeID value
     * @param int $sourceTypeID
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public function setSourceTypeID($sourceTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($sourceTypeID) && !is_numeric($sourceTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sourceTypeID)), __LINE__);
        }
        $this->SourceTypeID = $sourceTypeID;
        return $this;
    }
    /**
     * Get OwnerID value
     * @return string|null
     */
    public function getOwnerID()
    {
        return $this->OwnerID;
    }
    /**
     * Set OwnerID value
     * @param string $ownerID
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public function setOwnerID($ownerID = null)
    {
        // validation for constraint: string
        if (!is_null($ownerID) && !is_string($ownerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownerID)), __LINE__);
        }
        $this->OwnerID = $ownerID;
        return $this;
    }
    /**
     * Get StatusID value
     * @return string|null
     */
    public function getStatusID()
    {
        return $this->StatusID;
    }
    /**
     * Set StatusID value
     * @param string $statusID
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public function setStatusID($statusID = null)
    {
        // validation for constraint: string
        if (!is_null($statusID) && !is_string($statusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusID)), __LINE__);
        }
        $this->StatusID = $statusID;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return \App\Library\ExactTarget\StructType\ClientID|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param \App\Library\ExactTarget\StructType\ClientID $createdBy
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public function setCreatedBy(\App\Library\ExactTarget\StructType\ClientID $createdBy = null)
    {
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get ModifiedBy value
     * @return \App\Library\ExactTarget\StructType\ClientID|null
     */
    public function getModifiedBy()
    {
        return $this->ModifiedBy;
    }
    /**
     * Set ModifiedBy value
     * @param \App\Library\ExactTarget\StructType\ClientID $modifiedBy
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public function setModifiedBy(\App\Library\ExactTarget\StructType\ClientID $modifiedBy = null)
    {
        $this->ModifiedBy = $modifiedBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\FilterActivity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
