<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileTrigger StructType
 * @subpackage Structs
 */
class FileTrigger extends APIObject
{
    /**
     * The ExternalReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalReference;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessage;
    /**
     * The RequestParameterDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestParameterDetail;
    /**
     * The ResponseControlManifest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseControlManifest;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The LastPullDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastPullDate;
    /**
     * The ScheduledDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledDate;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The FileTriggerProgramID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileTriggerProgramID;
    /**
     * Constructor method for FileTrigger
     * @uses FileTrigger::setExternalReference()
     * @uses FileTrigger::setType()
     * @uses FileTrigger::setStatus()
     * @uses FileTrigger::setStatusMessage()
     * @uses FileTrigger::setRequestParameterDetail()
     * @uses FileTrigger::setResponseControlManifest()
     * @uses FileTrigger::setFileName()
     * @uses FileTrigger::setDescription()
     * @uses FileTrigger::setName()
     * @uses FileTrigger::setLastPullDate()
     * @uses FileTrigger::setScheduledDate()
     * @uses FileTrigger::setIsActive()
     * @uses FileTrigger::setFileTriggerProgramID()
     * @param string $externalReference
     * @param string $type
     * @param string $status
     * @param string $statusMessage
     * @param string $requestParameterDetail
     * @param string $responseControlManifest
     * @param string $fileName
     * @param string $description
     * @param string $name
     * @param string $lastPullDate
     * @param string $scheduledDate
     * @param bool $isActive
     * @param string $fileTriggerProgramID
     */
    public function __construct($externalReference = null, $type = null, $status = null, $statusMessage = null, $requestParameterDetail = null, $responseControlManifest = null, $fileName = null, $description = null, $name = null, $lastPullDate = null, $scheduledDate = null, $isActive = null, $fileTriggerProgramID = null)
    {
        $this
            ->setExternalReference($externalReference)
            ->setType($type)
            ->setStatus($status)
            ->setStatusMessage($statusMessage)
            ->setRequestParameterDetail($requestParameterDetail)
            ->setResponseControlManifest($responseControlManifest)
            ->setFileName($fileName)
            ->setDescription($description)
            ->setName($name)
            ->setLastPullDate($lastPullDate)
            ->setScheduledDate($scheduledDate)
            ->setIsActive($isActive)
            ->setFileTriggerProgramID($fileTriggerProgramID);
    }
    /**
     * Get ExternalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->ExternalReference;
    }
    /**
     * Set ExternalReference value
     * @param string $externalReference
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalReference)), __LINE__);
        }
        $this->ExternalReference = $externalReference;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get RequestParameterDetail value
     * @return string|null
     */
    public function getRequestParameterDetail()
    {
        return $this->RequestParameterDetail;
    }
    /**
     * Set RequestParameterDetail value
     * @param string $requestParameterDetail
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setRequestParameterDetail($requestParameterDetail = null)
    {
        // validation for constraint: string
        if (!is_null($requestParameterDetail) && !is_string($requestParameterDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestParameterDetail)), __LINE__);
        }
        $this->RequestParameterDetail = $requestParameterDetail;
        return $this;
    }
    /**
     * Get ResponseControlManifest value
     * @return string|null
     */
    public function getResponseControlManifest()
    {
        return $this->ResponseControlManifest;
    }
    /**
     * Set ResponseControlManifest value
     * @param string $responseControlManifest
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setResponseControlManifest($responseControlManifest = null)
    {
        // validation for constraint: string
        if (!is_null($responseControlManifest) && !is_string($responseControlManifest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseControlManifest)), __LINE__);
        }
        $this->ResponseControlManifest = $responseControlManifest;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get LastPullDate value
     * @return string|null
     */
    public function getLastPullDate()
    {
        return $this->LastPullDate;
    }
    /**
     * Set LastPullDate value
     * @param string $lastPullDate
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setLastPullDate($lastPullDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastPullDate) && !is_string($lastPullDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastPullDate)), __LINE__);
        }
        $this->LastPullDate = $lastPullDate;
        return $this;
    }
    /**
     * Get ScheduledDate value
     * @return string|null
     */
    public function getScheduledDate()
    {
        return $this->ScheduledDate;
    }
    /**
     * Set ScheduledDate value
     * @param string $scheduledDate
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setScheduledDate($scheduledDate = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDate) && !is_string($scheduledDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledDate)), __LINE__);
        }
        $this->ScheduledDate = $scheduledDate;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get FileTriggerProgramID value
     * @return string|null
     */
    public function getFileTriggerProgramID()
    {
        return $this->FileTriggerProgramID;
    }
    /**
     * Set FileTriggerProgramID value
     * @param string $fileTriggerProgramID
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public function setFileTriggerProgramID($fileTriggerProgramID = null)
    {
        // validation for constraint: string
        if (!is_null($fileTriggerProgramID) && !is_string($fileTriggerProgramID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileTriggerProgramID)), __LINE__);
        }
        $this->FileTriggerProgramID = $fileTriggerProgramID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\FileTrigger
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
