<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FieldMap StructType
 * @subpackage Structs
 */
class FieldMap extends AbstractStructBase
{
    /**
     * The DestinationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DestinationName;
    /**
     * The SourceName
     * @var string
     */
    public $SourceName;
    /**
     * The SourceOrdinal
     * @var int
     */
    public $SourceOrdinal;
    /**
     * Constructor method for FieldMap
     * @uses FieldMap::setDestinationName()
     * @uses FieldMap::setSourceName()
     * @uses FieldMap::setSourceOrdinal()
     * @param string $destinationName
     * @param string $sourceName
     * @param int $sourceOrdinal
     */
    public function __construct($destinationName = null, $sourceName = null, $sourceOrdinal = null)
    {
        $this
            ->setDestinationName($destinationName)
            ->setSourceName($sourceName)
            ->setSourceOrdinal($sourceOrdinal);
    }
    /**
     * Get DestinationName value
     * @return string
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param string $destinationName
     * @return \App\Library\ExactTarget\StructType\FieldMap
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationName)), __LINE__);
        }
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get SourceName value
     * @return string|null
     */
    public function getSourceName()
    {
        return $this->SourceName;
    }
    /**
     * Set SourceName value
     * @param string $sourceName
     * @return \App\Library\ExactTarget\StructType\FieldMap
     */
    public function setSourceName($sourceName = null)
    {
        // validation for constraint: string
        if (!is_null($sourceName) && !is_string($sourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceName)), __LINE__);
        }
        $this->SourceName = $sourceName;
        return $this;
    }
    /**
     * Get SourceOrdinal value
     * @return int|null
     */
    public function getSourceOrdinal()
    {
        return $this->SourceOrdinal;
    }
    /**
     * Set SourceOrdinal value
     * @param int $sourceOrdinal
     * @return \App\Library\ExactTarget\StructType\FieldMap
     */
    public function setSourceOrdinal($sourceOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($sourceOrdinal) && !is_numeric($sourceOrdinal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sourceOrdinal)), __LINE__);
        }
        $this->SourceOrdinal = $sourceOrdinal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\FieldMap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
