<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtractTemplate StructType
 * @subpackage Structs
 */
class ExtractTemplate extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The ConfigurationPage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConfigurationPage;
    /**
     * The PackageKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackageKey;
    /**
     * Constructor method for ExtractTemplate
     * @uses ExtractTemplate::setName()
     * @uses ExtractTemplate::setConfigurationPage()
     * @uses ExtractTemplate::setPackageKey()
     * @param string $name
     * @param string $configurationPage
     * @param string $packageKey
     */
    public function __construct($name = null, $configurationPage = null, $packageKey = null)
    {
        $this
            ->setName($name)
            ->setConfigurationPage($configurationPage)
            ->setPackageKey($packageKey);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\ExtractTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ConfigurationPage value
     * @return string|null
     */
    public function getConfigurationPage()
    {
        return $this->ConfigurationPage;
    }
    /**
     * Set ConfigurationPage value
     * @param string $configurationPage
     * @return \App\Library\ExactTarget\StructType\ExtractTemplate
     */
    public function setConfigurationPage($configurationPage = null)
    {
        // validation for constraint: string
        if (!is_null($configurationPage) && !is_string($configurationPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($configurationPage)), __LINE__);
        }
        $this->ConfigurationPage = $configurationPage;
        return $this;
    }
    /**
     * Get PackageKey value
     * @return string|null
     */
    public function getPackageKey()
    {
        return $this->PackageKey;
    }
    /**
     * Set PackageKey value
     * @param string $packageKey
     * @return \App\Library\ExactTarget\StructType\ExtractTemplate
     */
    public function setPackageKey($packageKey = null)
    {
        // validation for constraint: string
        if (!is_null($packageKey) && !is_string($packageKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageKey)), __LINE__);
        }
        $this->PackageKey = $packageKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ExtractTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
