<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtractRequestMsg StructType
 * @subpackage Structs
 */
class ExtractRequestMsg extends AbstractStructBase
{
    /**
     * The Requests
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ExtractRequest[]
     */
    public $Requests;
    /**
     * Constructor method for ExtractRequestMsg
     * @uses ExtractRequestMsg::setRequests()
     * @param \App\Library\ExactTarget\StructType\ExtractRequest[] $requests
     */
    public function __construct(array $requests = array())
    {
        $this
            ->setRequests($requests);
    }
    /**
     * Get Requests value
     * @return \App\Library\ExactTarget\StructType\ExtractRequest[]|null
     */
    public function getRequests()
    {
        return $this->Requests;
    }
    /**
     * Set Requests value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ExtractRequest[] $requests
     * @return \App\Library\ExactTarget\StructType\ExtractRequestMsg
     */
    public function setRequests(array $requests = array())
    {
        foreach ($requests as $extractRequestMsgRequestsItem) {
            // validation for constraint: itemType
            if (!$extractRequestMsgRequestsItem instanceof \App\Library\ExactTarget\StructType\ExtractRequest) {
                throw new \InvalidArgumentException(sprintf('The Requests property can only contain items of \App\Library\ExactTarget\StructType\ExtractRequest, "%s" given', is_object($extractRequestMsgRequestsItem) ? get_class($extractRequestMsgRequestsItem) : gettype($extractRequestMsgRequestsItem)), __LINE__);
            }
        }
        $this->Requests = $requests;
        return $this;
    }
    /**
     * Add item to Requests value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ExtractRequest $item
     * @return \App\Library\ExactTarget\StructType\ExtractRequestMsg
     */
    public function addToRequests(\App\Library\ExactTarget\StructType\ExtractRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\ExtractRequest) {
            throw new \InvalidArgumentException(sprintf('The Requests property can only contain items of \App\Library\ExactTarget\StructType\ExtractRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Requests[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ExtractRequestMsg
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
