<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtractParameterDescription StructType
 * @subpackage Structs
 */
class ExtractParameterDescription extends ParameterDescription
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The DataType
     * @var string
     */
    public $DataType;
    /**
     * The DefaultValue
     * @var string
     */
    public $DefaultValue;
    /**
     * The IsOptional
     * @var bool
     */
    public $IsOptional;
    /**
     * The DropDownList
     * @var string
     */
    public $DropDownList;
    /**
     * Constructor method for ExtractParameterDescription
     * @uses ExtractParameterDescription::setName()
     * @uses ExtractParameterDescription::setDataType()
     * @uses ExtractParameterDescription::setDefaultValue()
     * @uses ExtractParameterDescription::setIsOptional()
     * @uses ExtractParameterDescription::setDropDownList()
     * @param string $name
     * @param string $dataType
     * @param string $defaultValue
     * @param bool $isOptional
     * @param string $dropDownList
     */
    public function __construct($name = null, $dataType = null, $defaultValue = null, $isOptional = null, $dropDownList = null)
    {
        $this
            ->setName($name)
            ->setDataType($dataType)
            ->setDefaultValue($defaultValue)
            ->setIsOptional($isOptional)
            ->setDropDownList($dropDownList);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\ExtractParameterDescription
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get DataType value
     * @return string|null
     */
    public function getDataType()
    {
        return $this->DataType;
    }
    /**
     * Set DataType value
     * @uses \App\Library\ExactTarget\EnumType\ExtractParameterDataType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\ExtractParameterDataType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataType
     * @return \App\Library\ExactTarget\StructType\ExtractParameterDescription
     */
    public function setDataType($dataType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\ExtractParameterDataType::valueIsValid($dataType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dataType, implode(', ', \App\Library\ExactTarget\EnumType\ExtractParameterDataType::getValidValues())), __LINE__);
        }
        $this->DataType = $dataType;
        return $this;
    }
    /**
     * Get DefaultValue value
     * @return string|null
     */
    public function getDefaultValue()
    {
        return $this->DefaultValue;
    }
    /**
     * Set DefaultValue value
     * @param string $defaultValue
     * @return \App\Library\ExactTarget\StructType\ExtractParameterDescription
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: string
        if (!is_null($defaultValue) && !is_string($defaultValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultValue)), __LINE__);
        }
        $this->DefaultValue = $defaultValue;
        return $this;
    }
    /**
     * Get IsOptional value
     * @return bool|null
     */
    public function getIsOptional()
    {
        return $this->IsOptional;
    }
    /**
     * Set IsOptional value
     * @param bool $isOptional
     * @return \App\Library\ExactTarget\StructType\ExtractParameterDescription
     */
    public function setIsOptional($isOptional = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOptional) && !is_bool($isOptional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOptional)), __LINE__);
        }
        $this->IsOptional = $isOptional;
        return $this;
    }
    /**
     * Get DropDownList value
     * @return string|null
     */
    public function getDropDownList()
    {
        return $this->DropDownList;
    }
    /**
     * Set DropDownList value
     * @param string $dropDownList
     * @return \App\Library\ExactTarget\StructType\ExtractParameterDescription
     */
    public function setDropDownList($dropDownList = null)
    {
        // validation for constraint: string
        if (!is_null($dropDownList) && !is_string($dropDownList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dropDownList)), __LINE__);
        }
        $this->DropDownList = $dropDownList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ExtractParameterDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
