<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtendedProperties StructType
 * @subpackage Structs
 */
class ExtendedProperties extends AbstractStructBase
{
    /**
     * The ExtendedProperty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PropertyDefinition[]
     */
    public $ExtendedProperty;
    /**
     * Constructor method for ExtendedProperties
     * @uses ExtendedProperties::setExtendedProperty()
     * @param \App\Library\ExactTarget\StructType\PropertyDefinition[] $extendedProperty
     */
    public function __construct(array $extendedProperty = array())
    {
        $this
            ->setExtendedProperty($extendedProperty);
    }
    /**
     * Get ExtendedProperty value
     * @return \App\Library\ExactTarget\StructType\PropertyDefinition[]|null
     */
    public function getExtendedProperty()
    {
        return $this->ExtendedProperty;
    }
    /**
     * Set ExtendedProperty value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PropertyDefinition[] $extendedProperty
     * @return \App\Library\ExactTarget\StructType\ExtendedProperties
     */
    public function setExtendedProperty(array $extendedProperty = array())
    {
        foreach ($extendedProperty as $extendedPropertiesExtendedPropertyItem) {
            // validation for constraint: itemType
            if (!$extendedPropertiesExtendedPropertyItem instanceof \App\Library\ExactTarget\StructType\PropertyDefinition) {
                throw new \InvalidArgumentException(sprintf('The ExtendedProperty property can only contain items of \App\Library\ExactTarget\StructType\PropertyDefinition, "%s" given', is_object($extendedPropertiesExtendedPropertyItem) ? get_class($extendedPropertiesExtendedPropertyItem) : gettype($extendedPropertiesExtendedPropertyItem)), __LINE__);
            }
        }
        $this->ExtendedProperty = $extendedProperty;
        return $this;
    }
    /**
     * Add item to ExtendedProperty value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PropertyDefinition $item
     * @return \App\Library\ExactTarget\StructType\ExtendedProperties
     */
    public function addToExtendedProperty(\App\Library\ExactTarget\StructType\PropertyDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\PropertyDefinition) {
            throw new \InvalidArgumentException(sprintf('The ExtendedProperty property can only contain items of \App\Library\ExactTarget\StructType\PropertyDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExtendedProperty[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ExtendedProperties
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
