<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecuteRequestMsg StructType
 * @subpackage Structs
 */
class ExecuteRequestMsg extends AbstractStructBase
{
    /**
     * The Requests
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ExecuteRequest[]
     */
    public $Requests;
    /**
     * Constructor method for ExecuteRequestMsg
     * @uses ExecuteRequestMsg::setRequests()
     * @param \App\Library\ExactTarget\StructType\ExecuteRequest[] $requests
     */
    public function __construct(array $requests = array())
    {
        $this
            ->setRequests($requests);
    }
    /**
     * Get Requests value
     * @return \App\Library\ExactTarget\StructType\ExecuteRequest[]|null
     */
    public function getRequests()
    {
        return $this->Requests;
    }
    /**
     * Set Requests value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ExecuteRequest[] $requests
     * @return \App\Library\ExactTarget\StructType\ExecuteRequestMsg
     */
    public function setRequests(array $requests = array())
    {
        foreach ($requests as $executeRequestMsgRequestsItem) {
            // validation for constraint: itemType
            if (!$executeRequestMsgRequestsItem instanceof \App\Library\ExactTarget\StructType\ExecuteRequest) {
                throw new \InvalidArgumentException(sprintf('The Requests property can only contain items of \App\Library\ExactTarget\StructType\ExecuteRequest, "%s" given', is_object($executeRequestMsgRequestsItem) ? get_class($executeRequestMsgRequestsItem) : gettype($executeRequestMsgRequestsItem)), __LINE__);
            }
        }
        $this->Requests = $requests;
        return $this;
    }
    /**
     * Add item to Requests value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ExecuteRequest $item
     * @return \App\Library\ExactTarget\StructType\ExecuteRequestMsg
     */
    public function addToRequests(\App\Library\ExactTarget\StructType\ExecuteRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\ExecuteRequest) {
            throw new \InvalidArgumentException(sprintf('The Requests property can only contain items of \App\Library\ExactTarget\StructType\ExecuteRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Requests[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ExecuteRequestMsg
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
