<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailSendDefinition StructType
 * Meta informations extracted from the WSDL
 * - type: tns:EmailSendDefinition
 * @subpackage Structs
 */
class EmailSendDefinition extends SendDefinition
{
    /**
     * The SendDefinitionList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SendDefinitionList[]
     */
    public $SendDefinitionList;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Email
     */
    public $Email;
    /**
     * The BccEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BccEmail;
    /**
     * The AutoBccEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoBccEmail;
    /**
     * The TestEmailAddr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TestEmailAddr;
    /**
     * The EmailSubject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailSubject;
    /**
     * The DynamicEmailSubject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DynamicEmailSubject;
    /**
     * The IsMultipart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsMultipart;
    /**
     * The IsWrapped
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsWrapped;
    /**
     * The SendLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SendLimit;
    /**
     * The SendWindowOpen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendWindowOpen;
    /**
     * The SendWindowClose
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendWindowClose;
    /**
     * The SendWindowDelete
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SendWindowDelete;
    /**
     * The DeduplicateByEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DeduplicateByEmail;
    /**
     * The ExclusionFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExclusionFilter;
    /**
     * The TrackingUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TrackingUsers
     */
    public $TrackingUsers;
    /**
     * The Additional
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Additional;
    /**
     * The CCEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CCEmail;
    /**
     * The DeliveryScheduledTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryScheduledTime;
    /**
     * The MessageDeliveryType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageDeliveryType;
    /**
     * The IsSeedListSend
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsSeedListSend;
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TimeZone
     */
    public $TimeZone;
    /**
     * The SeedListOccurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SeedListOccurance;
    /**
     * The PreHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreHeader;
    /**
     * The ReplyToAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplyToAddress;
    /**
     * The ReplyToDisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplyToDisplayName;
    /**
     * Constructor method for EmailSendDefinition
     * @uses EmailSendDefinition::setSendDefinitionList()
     * @uses EmailSendDefinition::setEmail()
     * @uses EmailSendDefinition::setBccEmail()
     * @uses EmailSendDefinition::setAutoBccEmail()
     * @uses EmailSendDefinition::setTestEmailAddr()
     * @uses EmailSendDefinition::setEmailSubject()
     * @uses EmailSendDefinition::setDynamicEmailSubject()
     * @uses EmailSendDefinition::setIsMultipart()
     * @uses EmailSendDefinition::setIsWrapped()
     * @uses EmailSendDefinition::setSendLimit()
     * @uses EmailSendDefinition::setSendWindowOpen()
     * @uses EmailSendDefinition::setSendWindowClose()
     * @uses EmailSendDefinition::setSendWindowDelete()
     * @uses EmailSendDefinition::setDeduplicateByEmail()
     * @uses EmailSendDefinition::setExclusionFilter()
     * @uses EmailSendDefinition::setTrackingUsers()
     * @uses EmailSendDefinition::setAdditional()
     * @uses EmailSendDefinition::setCCEmail()
     * @uses EmailSendDefinition::setDeliveryScheduledTime()
     * @uses EmailSendDefinition::setMessageDeliveryType()
     * @uses EmailSendDefinition::setIsSeedListSend()
     * @uses EmailSendDefinition::setTimeZone()
     * @uses EmailSendDefinition::setSeedListOccurance()
     * @uses EmailSendDefinition::setPreHeader()
     * @uses EmailSendDefinition::setReplyToAddress()
     * @uses EmailSendDefinition::setReplyToDisplayName()
     * @param \App\Library\ExactTarget\StructType\SendDefinitionList[] $sendDefinitionList
     * @param \App\Library\ExactTarget\StructType\Email $email
     * @param string $bccEmail
     * @param string $autoBccEmail
     * @param string $testEmailAddr
     * @param string $emailSubject
     * @param string $dynamicEmailSubject
     * @param bool $isMultipart
     * @param bool $isWrapped
     * @param int $sendLimit
     * @param string $sendWindowOpen
     * @param string $sendWindowClose
     * @param bool $sendWindowDelete
     * @param bool $deduplicateByEmail
     * @param string $exclusionFilter
     * @param \App\Library\ExactTarget\StructType\TrackingUsers $trackingUsers
     * @param string $additional
     * @param string $cCEmail
     * @param string $deliveryScheduledTime
     * @param string $messageDeliveryType
     * @param bool $isSeedListSend
     * @param \App\Library\ExactTarget\StructType\TimeZone $timeZone
     * @param int $seedListOccurance
     * @param string $preHeader
     * @param string $replyToAddress
     * @param string $replyToDisplayName
     */
    public function __construct(array $sendDefinitionList = array(), \App\Library\ExactTarget\StructType\Email $email = null, $bccEmail = null, $autoBccEmail = null, $testEmailAddr = null, $emailSubject = null, $dynamicEmailSubject = null, $isMultipart = null, $isWrapped = null, $sendLimit = null, $sendWindowOpen = null, $sendWindowClose = null, $sendWindowDelete = null, $deduplicateByEmail = null, $exclusionFilter = null, \App\Library\ExactTarget\StructType\TrackingUsers $trackingUsers = null, $additional = null, $cCEmail = null, $deliveryScheduledTime = null, $messageDeliveryType = null, $isSeedListSend = null, \App\Library\ExactTarget\StructType\TimeZone $timeZone = null, $seedListOccurance = null, $preHeader = null, $replyToAddress = null, $replyToDisplayName = null)
    {
        $this
            ->setSendDefinitionList($sendDefinitionList)
            ->setEmail($email)
            ->setBccEmail($bccEmail)
            ->setAutoBccEmail($autoBccEmail)
            ->setTestEmailAddr($testEmailAddr)
            ->setEmailSubject($emailSubject)
            ->setDynamicEmailSubject($dynamicEmailSubject)
            ->setIsMultipart($isMultipart)
            ->setIsWrapped($isWrapped)
            ->setSendLimit($sendLimit)
            ->setSendWindowOpen($sendWindowOpen)
            ->setSendWindowClose($sendWindowClose)
            ->setSendWindowDelete($sendWindowDelete)
            ->setDeduplicateByEmail($deduplicateByEmail)
            ->setExclusionFilter($exclusionFilter)
            ->setTrackingUsers($trackingUsers)
            ->setAdditional($additional)
            ->setCCEmail($cCEmail)
            ->setDeliveryScheduledTime($deliveryScheduledTime)
            ->setMessageDeliveryType($messageDeliveryType)
            ->setIsSeedListSend($isSeedListSend)
            ->setTimeZone($timeZone)
            ->setSeedListOccurance($seedListOccurance)
            ->setPreHeader($preHeader)
            ->setReplyToAddress($replyToAddress)
            ->setReplyToDisplayName($replyToDisplayName);
    }
    /**
     * Get SendDefinitionList value
     * @return \App\Library\ExactTarget\StructType\SendDefinitionList[]|null
     */
    public function getSendDefinitionList()
    {
        return $this->SendDefinitionList;
    }
    /**
     * Set SendDefinitionList value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\SendDefinitionList[] $sendDefinitionList
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setSendDefinitionList(array $sendDefinitionList = array())
    {
        foreach ($sendDefinitionList as $emailSendDefinitionSendDefinitionListItem) {
            // validation for constraint: itemType
            if (!$emailSendDefinitionSendDefinitionListItem instanceof \App\Library\ExactTarget\StructType\SendDefinitionList) {
                throw new \InvalidArgumentException(sprintf('The SendDefinitionList property can only contain items of \App\Library\ExactTarget\StructType\SendDefinitionList, "%s" given', is_object($emailSendDefinitionSendDefinitionListItem) ? get_class($emailSendDefinitionSendDefinitionListItem) : gettype($emailSendDefinitionSendDefinitionListItem)), __LINE__);
            }
        }
        $this->SendDefinitionList = $sendDefinitionList;
        return $this;
    }
    /**
     * Add item to SendDefinitionList value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\SendDefinitionList $item
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function addToSendDefinitionList(\App\Library\ExactTarget\StructType\SendDefinitionList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\SendDefinitionList) {
            throw new \InvalidArgumentException(sprintf('The SendDefinitionList property can only contain items of \App\Library\ExactTarget\StructType\SendDefinitionList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SendDefinitionList[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \App\Library\ExactTarget\StructType\Email|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \App\Library\ExactTarget\StructType\Email $email
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setEmail(\App\Library\ExactTarget\StructType\Email $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get BccEmail value
     * @return string|null
     */
    public function getBccEmail()
    {
        return $this->BccEmail;
    }
    /**
     * Set BccEmail value
     * @param string $bccEmail
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setBccEmail($bccEmail = null)
    {
        // validation for constraint: string
        if (!is_null($bccEmail) && !is_string($bccEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bccEmail)), __LINE__);
        }
        $this->BccEmail = $bccEmail;
        return $this;
    }
    /**
     * Get AutoBccEmail value
     * @return string|null
     */
    public function getAutoBccEmail()
    {
        return $this->AutoBccEmail;
    }
    /**
     * Set AutoBccEmail value
     * @param string $autoBccEmail
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setAutoBccEmail($autoBccEmail = null)
    {
        // validation for constraint: string
        if (!is_null($autoBccEmail) && !is_string($autoBccEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoBccEmail)), __LINE__);
        }
        $this->AutoBccEmail = $autoBccEmail;
        return $this;
    }
    /**
     * Get TestEmailAddr value
     * @return string|null
     */
    public function getTestEmailAddr()
    {
        return $this->TestEmailAddr;
    }
    /**
     * Set TestEmailAddr value
     * @param string $testEmailAddr
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setTestEmailAddr($testEmailAddr = null)
    {
        // validation for constraint: string
        if (!is_null($testEmailAddr) && !is_string($testEmailAddr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($testEmailAddr)), __LINE__);
        }
        $this->TestEmailAddr = $testEmailAddr;
        return $this;
    }
    /**
     * Get EmailSubject value
     * @return string|null
     */
    public function getEmailSubject()
    {
        return $this->EmailSubject;
    }
    /**
     * Set EmailSubject value
     * @param string $emailSubject
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setEmailSubject($emailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($emailSubject) && !is_string($emailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailSubject)), __LINE__);
        }
        $this->EmailSubject = $emailSubject;
        return $this;
    }
    /**
     * Get DynamicEmailSubject value
     * @return string|null
     */
    public function getDynamicEmailSubject()
    {
        return $this->DynamicEmailSubject;
    }
    /**
     * Set DynamicEmailSubject value
     * @param string $dynamicEmailSubject
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setDynamicEmailSubject($dynamicEmailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicEmailSubject) && !is_string($dynamicEmailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dynamicEmailSubject)), __LINE__);
        }
        $this->DynamicEmailSubject = $dynamicEmailSubject;
        return $this;
    }
    /**
     * Get IsMultipart value
     * @return bool|null
     */
    public function getIsMultipart()
    {
        return $this->IsMultipart;
    }
    /**
     * Set IsMultipart value
     * @param bool $isMultipart
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setIsMultipart($isMultipart = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMultipart) && !is_bool($isMultipart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMultipart)), __LINE__);
        }
        $this->IsMultipart = $isMultipart;
        return $this;
    }
    /**
     * Get IsWrapped value
     * @return bool|null
     */
    public function getIsWrapped()
    {
        return $this->IsWrapped;
    }
    /**
     * Set IsWrapped value
     * @param bool $isWrapped
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setIsWrapped($isWrapped = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWrapped) && !is_bool($isWrapped)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isWrapped)), __LINE__);
        }
        $this->IsWrapped = $isWrapped;
        return $this;
    }
    /**
     * Get SendLimit value
     * @return int|null
     */
    public function getSendLimit()
    {
        return $this->SendLimit;
    }
    /**
     * Set SendLimit value
     * @param int $sendLimit
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setSendLimit($sendLimit = null)
    {
        // validation for constraint: int
        if (!is_null($sendLimit) && !is_numeric($sendLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sendLimit)), __LINE__);
        }
        $this->SendLimit = $sendLimit;
        return $this;
    }
    /**
     * Get SendWindowOpen value
     * @return string|null
     */
    public function getSendWindowOpen()
    {
        return $this->SendWindowOpen;
    }
    /**
     * Set SendWindowOpen value
     * @param string $sendWindowOpen
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setSendWindowOpen($sendWindowOpen = null)
    {
        // validation for constraint: string
        if (!is_null($sendWindowOpen) && !is_string($sendWindowOpen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendWindowOpen)), __LINE__);
        }
        $this->SendWindowOpen = $sendWindowOpen;
        return $this;
    }
    /**
     * Get SendWindowClose value
     * @return string|null
     */
    public function getSendWindowClose()
    {
        return $this->SendWindowClose;
    }
    /**
     * Set SendWindowClose value
     * @param string $sendWindowClose
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setSendWindowClose($sendWindowClose = null)
    {
        // validation for constraint: string
        if (!is_null($sendWindowClose) && !is_string($sendWindowClose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendWindowClose)), __LINE__);
        }
        $this->SendWindowClose = $sendWindowClose;
        return $this;
    }
    /**
     * Get SendWindowDelete value
     * @return bool|null
     */
    public function getSendWindowDelete()
    {
        return $this->SendWindowDelete;
    }
    /**
     * Set SendWindowDelete value
     * @param bool $sendWindowDelete
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setSendWindowDelete($sendWindowDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendWindowDelete) && !is_bool($sendWindowDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendWindowDelete)), __LINE__);
        }
        $this->SendWindowDelete = $sendWindowDelete;
        return $this;
    }
    /**
     * Get DeduplicateByEmail value
     * @return bool|null
     */
    public function getDeduplicateByEmail()
    {
        return $this->DeduplicateByEmail;
    }
    /**
     * Set DeduplicateByEmail value
     * @param bool $deduplicateByEmail
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setDeduplicateByEmail($deduplicateByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($deduplicateByEmail) && !is_bool($deduplicateByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deduplicateByEmail)), __LINE__);
        }
        $this->DeduplicateByEmail = $deduplicateByEmail;
        return $this;
    }
    /**
     * Get ExclusionFilter value
     * @return string|null
     */
    public function getExclusionFilter()
    {
        return $this->ExclusionFilter;
    }
    /**
     * Set ExclusionFilter value
     * @param string $exclusionFilter
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setExclusionFilter($exclusionFilter = null)
    {
        // validation for constraint: string
        if (!is_null($exclusionFilter) && !is_string($exclusionFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exclusionFilter)), __LINE__);
        }
        $this->ExclusionFilter = $exclusionFilter;
        return $this;
    }
    /**
     * Get TrackingUsers value
     * @return \App\Library\ExactTarget\StructType\TrackingUsers|null
     */
    public function getTrackingUsers()
    {
        return $this->TrackingUsers;
    }
    /**
     * Set TrackingUsers value
     * @param \App\Library\ExactTarget\StructType\TrackingUsers $trackingUsers
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setTrackingUsers(\App\Library\ExactTarget\StructType\TrackingUsers $trackingUsers = null)
    {
        $this->TrackingUsers = $trackingUsers;
        return $this;
    }
    /**
     * Get Additional value
     * @return string|null
     */
    public function getAdditional()
    {
        return $this->Additional;
    }
    /**
     * Set Additional value
     * @param string $additional
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setAdditional($additional = null)
    {
        // validation for constraint: string
        if (!is_null($additional) && !is_string($additional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additional)), __LINE__);
        }
        $this->Additional = $additional;
        return $this;
    }
    /**
     * Get CCEmail value
     * @return string|null
     */
    public function getCCEmail()
    {
        return $this->CCEmail;
    }
    /**
     * Set CCEmail value
     * @param string $cCEmail
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setCCEmail($cCEmail = null)
    {
        // validation for constraint: string
        if (!is_null($cCEmail) && !is_string($cCEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cCEmail)), __LINE__);
        }
        $this->CCEmail = $cCEmail;
        return $this;
    }
    /**
     * Get DeliveryScheduledTime value
     * @return string|null
     */
    public function getDeliveryScheduledTime()
    {
        return $this->DeliveryScheduledTime;
    }
    /**
     * Set DeliveryScheduledTime value
     * @param string $deliveryScheduledTime
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setDeliveryScheduledTime($deliveryScheduledTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryScheduledTime) && !is_string($deliveryScheduledTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryScheduledTime)), __LINE__);
        }
        $this->DeliveryScheduledTime = $deliveryScheduledTime;
        return $this;
    }
    /**
     * Get MessageDeliveryType value
     * @return string|null
     */
    public function getMessageDeliveryType()
    {
        return $this->MessageDeliveryType;
    }
    /**
     * Set MessageDeliveryType value
     * @uses \App\Library\ExactTarget\EnumType\MessageDeliveryTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\MessageDeliveryTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageDeliveryType
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setMessageDeliveryType($messageDeliveryType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\MessageDeliveryTypeEnum::valueIsValid($messageDeliveryType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $messageDeliveryType, implode(', ', \App\Library\ExactTarget\EnumType\MessageDeliveryTypeEnum::getValidValues())), __LINE__);
        }
        $this->MessageDeliveryType = $messageDeliveryType;
        return $this;
    }
    /**
     * Get IsSeedListSend value
     * @return bool|null
     */
    public function getIsSeedListSend()
    {
        return $this->IsSeedListSend;
    }
    /**
     * Set IsSeedListSend value
     * @param bool $isSeedListSend
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setIsSeedListSend($isSeedListSend = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeedListSend) && !is_bool($isSeedListSend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSeedListSend)), __LINE__);
        }
        $this->IsSeedListSend = $isSeedListSend;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return \App\Library\ExactTarget\StructType\TimeZone|null
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param \App\Library\ExactTarget\StructType\TimeZone $timeZone
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setTimeZone(\App\Library\ExactTarget\StructType\TimeZone $timeZone = null)
    {
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Get SeedListOccurance value
     * @return int|null
     */
    public function getSeedListOccurance()
    {
        return $this->SeedListOccurance;
    }
    /**
     * Set SeedListOccurance value
     * @param int $seedListOccurance
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setSeedListOccurance($seedListOccurance = null)
    {
        // validation for constraint: int
        if (!is_null($seedListOccurance) && !is_numeric($seedListOccurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seedListOccurance)), __LINE__);
        }
        $this->SeedListOccurance = $seedListOccurance;
        return $this;
    }
    /**
     * Get PreHeader value
     * @return string|null
     */
    public function getPreHeader()
    {
        return $this->PreHeader;
    }
    /**
     * Set PreHeader value
     * @param string $preHeader
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setPreHeader($preHeader = null)
    {
        // validation for constraint: string
        if (!is_null($preHeader) && !is_string($preHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preHeader)), __LINE__);
        }
        $this->PreHeader = $preHeader;
        return $this;
    }
    /**
     * Get ReplyToAddress value
     * @return string|null
     */
    public function getReplyToAddress()
    {
        return $this->ReplyToAddress;
    }
    /**
     * Set ReplyToAddress value
     * @param string $replyToAddress
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setReplyToAddress($replyToAddress = null)
    {
        // validation for constraint: string
        if (!is_null($replyToAddress) && !is_string($replyToAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replyToAddress)), __LINE__);
        }
        $this->ReplyToAddress = $replyToAddress;
        return $this;
    }
    /**
     * Get ReplyToDisplayName value
     * @return string|null
     */
    public function getReplyToDisplayName()
    {
        return $this->ReplyToDisplayName;
    }
    /**
     * Set ReplyToDisplayName value
     * @param string $replyToDisplayName
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public function setReplyToDisplayName($replyToDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($replyToDisplayName) && !is_string($replyToDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replyToDisplayName)), __LINE__);
        }
        $this->ReplyToDisplayName = $replyToDisplayName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\EmailSendDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
