<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Definitions StructType
 * @subpackage Structs
 */
class Definitions extends AbstractStructBase
{
    /**
     * The Definition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\InteractionBaseObject[]
     */
    public $Definition;
    /**
     * Constructor method for Definitions
     * @uses Definitions::setDefinition()
     * @param \App\Library\ExactTarget\StructType\InteractionBaseObject[] $definition
     */
    public function __construct(array $definition = array())
    {
        $this
            ->setDefinition($definition);
    }
    /**
     * Get Definition value
     * @return \App\Library\ExactTarget\StructType\InteractionBaseObject[]|null
     */
    public function getDefinition()
    {
        return $this->Definition;
    }
    /**
     * Set Definition value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\InteractionBaseObject[] $definition
     * @return \App\Library\ExactTarget\StructType\Definitions
     */
    public function setDefinition(array $definition = array())
    {
        foreach ($definition as $definitionsDefinitionItem) {
            // validation for constraint: itemType
            if (!$definitionsDefinitionItem instanceof \App\Library\ExactTarget\StructType\InteractionBaseObject) {
                throw new \InvalidArgumentException(sprintf('The Definition property can only contain items of \App\Library\ExactTarget\StructType\InteractionBaseObject, "%s" given', is_object($definitionsDefinitionItem) ? get_class($definitionsDefinitionItem) : gettype($definitionsDefinitionItem)), __LINE__);
            }
        }
        $this->Definition = $definition;
        return $this;
    }
    /**
     * Add item to Definition value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\InteractionBaseObject $item
     * @return \App\Library\ExactTarget\StructType\Definitions
     */
    public function addToDefinition(\App\Library\ExactTarget\StructType\InteractionBaseObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\InteractionBaseObject) {
            throw new \InvalidArgumentException(sprintf('The Definition property can only contain items of \App\Library\ExactTarget\StructType\InteractionBaseObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Definition[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Definitions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
