<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DefinitionResponseMsg StructType
 * @subpackage Structs
 */
class DefinitionResponseMsg extends AbstractStructBase
{
    /**
     * The ObjectDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ObjectDefinition[]
     */
    public $ObjectDefinition;
    /**
     * The RequestID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestID;
    /**
     * Constructor method for DefinitionResponseMsg
     * @uses DefinitionResponseMsg::setObjectDefinition()
     * @uses DefinitionResponseMsg::setRequestID()
     * @param \App\Library\ExactTarget\StructType\ObjectDefinition[] $objectDefinition
     * @param string $requestID
     */
    public function __construct(array $objectDefinition = array(), $requestID = null)
    {
        $this
            ->setObjectDefinition($objectDefinition)
            ->setRequestID($requestID);
    }
    /**
     * Get ObjectDefinition value
     * @return \App\Library\ExactTarget\StructType\ObjectDefinition[]|null
     */
    public function getObjectDefinition()
    {
        return $this->ObjectDefinition;
    }
    /**
     * Set ObjectDefinition value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ObjectDefinition[] $objectDefinition
     * @return \App\Library\ExactTarget\StructType\DefinitionResponseMsg
     */
    public function setObjectDefinition(array $objectDefinition = array())
    {
        foreach ($objectDefinition as $definitionResponseMsgObjectDefinitionItem) {
            // validation for constraint: itemType
            if (!$definitionResponseMsgObjectDefinitionItem instanceof \App\Library\ExactTarget\StructType\ObjectDefinition) {
                throw new \InvalidArgumentException(sprintf('The ObjectDefinition property can only contain items of \App\Library\ExactTarget\StructType\ObjectDefinition, "%s" given', is_object($definitionResponseMsgObjectDefinitionItem) ? get_class($definitionResponseMsgObjectDefinitionItem) : gettype($definitionResponseMsgObjectDefinitionItem)), __LINE__);
            }
        }
        $this->ObjectDefinition = $objectDefinition;
        return $this;
    }
    /**
     * Add item to ObjectDefinition value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ObjectDefinition $item
     * @return \App\Library\ExactTarget\StructType\DefinitionResponseMsg
     */
    public function addToObjectDefinition(\App\Library\ExactTarget\StructType\ObjectDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\ObjectDefinition) {
            throw new \InvalidArgumentException(sprintf('The ObjectDefinition property can only contain items of \App\Library\ExactTarget\StructType\ObjectDefinition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ObjectDefinition[] = $item;
        return $this;
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \App\Library\ExactTarget\StructType\DefinitionResponseMsg
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\DefinitionResponseMsg
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
