<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataFolder StructType
 * @subpackage Structs
 */
class DataFolder extends APIObject
{
    /**
     * The ParentFolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DataFolder
     */
    public $ParentFolder;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ContentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ContentType;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The IsEditable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsEditable;
    /**
     * The AllowChildren
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowChildren;
    /**
     * Constructor method for DataFolder
     * @uses DataFolder::setParentFolder()
     * @uses DataFolder::setName()
     * @uses DataFolder::setDescription()
     * @uses DataFolder::setContentType()
     * @uses DataFolder::setIsActive()
     * @uses DataFolder::setIsEditable()
     * @uses DataFolder::setAllowChildren()
     * @param \App\Library\ExactTarget\StructType\DataFolder $parentFolder
     * @param string $name
     * @param string $description
     * @param string $contentType
     * @param bool $isActive
     * @param bool $isEditable
     * @param bool $allowChildren
     */
    public function __construct(\App\Library\ExactTarget\StructType\DataFolder $parentFolder = null, $name = null, $description = null, $contentType = null, $isActive = null, $isEditable = null, $allowChildren = null)
    {
        $this
            ->setParentFolder($parentFolder)
            ->setName($name)
            ->setDescription($description)
            ->setContentType($contentType)
            ->setIsActive($isActive)
            ->setIsEditable($isEditable)
            ->setAllowChildren($allowChildren);
    }
    /**
     * Get ParentFolder value
     * @return \App\Library\ExactTarget\StructType\DataFolder|null
     */
    public function getParentFolder()
    {
        return $this->ParentFolder;
    }
    /**
     * Set ParentFolder value
     * @param \App\Library\ExactTarget\StructType\DataFolder $parentFolder
     * @return \App\Library\ExactTarget\StructType\DataFolder
     */
    public function setParentFolder(\App\Library\ExactTarget\StructType\DataFolder $parentFolder = null)
    {
        $this->ParentFolder = $parentFolder;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\DataFolder
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\DataFolder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \App\Library\ExactTarget\StructType\DataFolder
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \App\Library\ExactTarget\StructType\DataFolder
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsEditable value
     * @return bool|null
     */
    public function getIsEditable()
    {
        return $this->IsEditable;
    }
    /**
     * Set IsEditable value
     * @param bool $isEditable
     * @return \App\Library\ExactTarget\StructType\DataFolder
     */
    public function setIsEditable($isEditable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEditable) && !is_bool($isEditable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEditable)), __LINE__);
        }
        $this->IsEditable = $isEditable;
        return $this;
    }
    /**
     * Get AllowChildren value
     * @return bool|null
     */
    public function getAllowChildren()
    {
        return $this->AllowChildren;
    }
    /**
     * Set AllowChildren value
     * @param bool $allowChildren
     * @return \App\Library\ExactTarget\StructType\DataFolder
     */
    public function setAllowChildren($allowChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowChildren) && !is_bool($allowChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowChildren)), __LINE__);
        }
        $this->AllowChildren = $allowChildren;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\DataFolder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
