<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataExtensionField StructType
 * @subpackage Structs
 */
class DataExtensionField extends PropertyDefinition
{
    /**
     * The Ordinal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * The IsPrimaryKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrimaryKey;
    /**
     * The FieldType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldType;
    /**
     * The DataExtension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DataExtension
     */
    public $DataExtension;
    /**
     * The StorageType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StorageType;
    /**
     * Constructor method for DataExtensionField
     * @uses DataExtensionField::setOrdinal()
     * @uses DataExtensionField::setIsPrimaryKey()
     * @uses DataExtensionField::setFieldType()
     * @uses DataExtensionField::setDataExtension()
     * @uses DataExtensionField::setStorageType()
     * @param int $ordinal
     * @param bool $isPrimaryKey
     * @param string $fieldType
     * @param \App\Library\ExactTarget\StructType\DataExtension $dataExtension
     * @param string $storageType
     */
    public function __construct($ordinal = null, $isPrimaryKey = null, $fieldType = null, \App\Library\ExactTarget\StructType\DataExtension $dataExtension = null, $storageType = null)
    {
        $this
            ->setOrdinal($ordinal)
            ->setIsPrimaryKey($isPrimaryKey)
            ->setFieldType($fieldType)
            ->setDataExtension($dataExtension)
            ->setStorageType($storageType);
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \App\Library\ExactTarget\StructType\DataExtensionField
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !is_numeric($ordinal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get IsPrimaryKey value
     * @return bool|null
     */
    public function getIsPrimaryKey()
    {
        return $this->IsPrimaryKey;
    }
    /**
     * Set IsPrimaryKey value
     * @param bool $isPrimaryKey
     * @return \App\Library\ExactTarget\StructType\DataExtensionField
     */
    public function setIsPrimaryKey($isPrimaryKey = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimaryKey) && !is_bool($isPrimaryKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPrimaryKey)), __LINE__);
        }
        $this->IsPrimaryKey = $isPrimaryKey;
        return $this;
    }
    /**
     * Get FieldType value
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->FieldType;
    }
    /**
     * Set FieldType value
     * @uses \App\Library\ExactTarget\EnumType\DataExtensionFieldType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DataExtensionFieldType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fieldType
     * @return \App\Library\ExactTarget\StructType\DataExtensionField
     */
    public function setFieldType($fieldType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DataExtensionFieldType::valueIsValid($fieldType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fieldType, implode(', ', \App\Library\ExactTarget\EnumType\DataExtensionFieldType::getValidValues())), __LINE__);
        }
        $this->FieldType = $fieldType;
        return $this;
    }
    /**
     * Get DataExtension value
     * @return \App\Library\ExactTarget\StructType\DataExtension|null
     */
    public function getDataExtension()
    {
        return $this->DataExtension;
    }
    /**
     * Set DataExtension value
     * @param \App\Library\ExactTarget\StructType\DataExtension $dataExtension
     * @return \App\Library\ExactTarget\StructType\DataExtensionField
     */
    public function setDataExtension(\App\Library\ExactTarget\StructType\DataExtension $dataExtension = null)
    {
        $this->DataExtension = $dataExtension;
        return $this;
    }
    /**
     * Get StorageType value
     * @return string|null
     */
    public function getStorageType()
    {
        return $this->StorageType;
    }
    /**
     * Set StorageType value
     * @uses \App\Library\ExactTarget\EnumType\DataExtensionFieldStorageType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DataExtensionFieldStorageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $storageType
     * @return \App\Library\ExactTarget\StructType\DataExtensionField
     */
    public function setStorageType($storageType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DataExtensionFieldStorageType::valueIsValid($storageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $storageType, implode(', ', \App\Library\ExactTarget\EnumType\DataExtensionFieldStorageType::getValidValues())), __LINE__);
        }
        $this->StorageType = $storageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\DataExtensionField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
