<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataExtensionDeleteResult StructType
 * @subpackage Structs
 */
class DataExtensionDeleteResult extends DeleteResult
{
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The KeyErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\KeyErrors
     */
    public $KeyErrors;
    /**
     * Constructor method for DataExtensionDeleteResult
     * @uses DataExtensionDeleteResult::setErrorMessage()
     * @uses DataExtensionDeleteResult::setKeyErrors()
     * @param string $errorMessage
     * @param \App\Library\ExactTarget\StructType\KeyErrors $keyErrors
     */
    public function __construct($errorMessage = null, \App\Library\ExactTarget\StructType\KeyErrors $keyErrors = null)
    {
        $this
            ->setErrorMessage($errorMessage)
            ->setKeyErrors($keyErrors);
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \App\Library\ExactTarget\StructType\DataExtensionDeleteResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get KeyErrors value
     * @return \App\Library\ExactTarget\StructType\KeyErrors|null
     */
    public function getKeyErrors()
    {
        return $this->KeyErrors;
    }
    /**
     * Set KeyErrors value
     * @param \App\Library\ExactTarget\StructType\KeyErrors $keyErrors
     * @return \App\Library\ExactTarget\StructType\DataExtensionDeleteResult
     */
    public function setKeyErrors(\App\Library\ExactTarget\StructType\KeyErrors $keyErrors = null)
    {
        $this->KeyErrors = $keyErrors;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\DataExtensionDeleteResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
