<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentArea StructType
 * @subpackage Structs
 */
class ContentArea extends APIObject
{
    /**
     * The Key
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Key;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Content;
    /**
     * The IsBlank
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsBlank;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CategoryID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Layout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Layout;
    /**
     * The IsDynamicContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsDynamicContent;
    /**
     * The IsSurvey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsSurvey;
    /**
     * The BackgroundColor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BackgroundColor;
    /**
     * The BorderColor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BorderColor;
    /**
     * The BorderWidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $BorderWidth;
    /**
     * The Cellpadding
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Cellpadding;
    /**
     * The Cellspacing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Cellspacing;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Width;
    /**
     * The FontFamily
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FontFamily;
    /**
     * The HasFontSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $HasFontSize;
    /**
     * The IsLocked
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsLocked;
    /**
     * Constructor method for ContentArea
     * @uses ContentArea::setKey()
     * @uses ContentArea::setContent()
     * @uses ContentArea::setIsBlank()
     * @uses ContentArea::setCategoryID()
     * @uses ContentArea::setName()
     * @uses ContentArea::setLayout()
     * @uses ContentArea::setIsDynamicContent()
     * @uses ContentArea::setIsSurvey()
     * @uses ContentArea::setBackgroundColor()
     * @uses ContentArea::setBorderColor()
     * @uses ContentArea::setBorderWidth()
     * @uses ContentArea::setCellpadding()
     * @uses ContentArea::setCellspacing()
     * @uses ContentArea::setWidth()
     * @uses ContentArea::setFontFamily()
     * @uses ContentArea::setHasFontSize()
     * @uses ContentArea::setIsLocked()
     * @param string $key
     * @param string $content
     * @param bool $isBlank
     * @param int $categoryID
     * @param string $name
     * @param string $layout
     * @param bool $isDynamicContent
     * @param bool $isSurvey
     * @param string $backgroundColor
     * @param string $borderColor
     * @param int $borderWidth
     * @param int $cellpadding
     * @param int $cellspacing
     * @param string $width
     * @param string $fontFamily
     * @param bool $hasFontSize
     * @param bool $isLocked
     */
    public function __construct($key = null, $content = null, $isBlank = null, $categoryID = null, $name = null, $layout = null, $isDynamicContent = null, $isSurvey = null, $backgroundColor = null, $borderColor = null, $borderWidth = null, $cellpadding = null, $cellspacing = null, $width = null, $fontFamily = null, $hasFontSize = null, $isLocked = null)
    {
        $this
            ->setKey($key)
            ->setContent($content)
            ->setIsBlank($isBlank)
            ->setCategoryID($categoryID)
            ->setName($name)
            ->setLayout($layout)
            ->setIsDynamicContent($isDynamicContent)
            ->setIsSurvey($isSurvey)
            ->setBackgroundColor($backgroundColor)
            ->setBorderColor($borderColor)
            ->setBorderWidth($borderWidth)
            ->setCellpadding($cellpadding)
            ->setCellspacing($cellspacing)
            ->setWidth($width)
            ->setFontFamily($fontFamily)
            ->setHasFontSize($hasFontSize)
            ->setIsLocked($isLocked);
    }
    /**
     * Get Key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get IsBlank value
     * @return bool|null
     */
    public function getIsBlank()
    {
        return $this->IsBlank;
    }
    /**
     * Set IsBlank value
     * @param bool $isBlank
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setIsBlank($isBlank = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBlank) && !is_bool($isBlank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBlank)), __LINE__);
        }
        $this->IsBlank = $isBlank;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Layout value
     * @return string|null
     */
    public function getLayout()
    {
        return $this->Layout;
    }
    /**
     * Set Layout value
     * @uses \App\Library\ExactTarget\EnumType\LayoutType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\LayoutType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layout
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setLayout($layout = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\LayoutType::valueIsValid($layout)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $layout, implode(', ', \App\Library\ExactTarget\EnumType\LayoutType::getValidValues())), __LINE__);
        }
        $this->Layout = $layout;
        return $this;
    }
    /**
     * Get IsDynamicContent value
     * @return bool|null
     */
    public function getIsDynamicContent()
    {
        return $this->IsDynamicContent;
    }
    /**
     * Set IsDynamicContent value
     * @param bool $isDynamicContent
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setIsDynamicContent($isDynamicContent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDynamicContent) && !is_bool($isDynamicContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDynamicContent)), __LINE__);
        }
        $this->IsDynamicContent = $isDynamicContent;
        return $this;
    }
    /**
     * Get IsSurvey value
     * @return bool|null
     */
    public function getIsSurvey()
    {
        return $this->IsSurvey;
    }
    /**
     * Set IsSurvey value
     * @param bool $isSurvey
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setIsSurvey($isSurvey = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSurvey) && !is_bool($isSurvey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSurvey)), __LINE__);
        }
        $this->IsSurvey = $isSurvey;
        return $this;
    }
    /**
     * Get BackgroundColor value
     * @return string|null
     */
    public function getBackgroundColor()
    {
        return $this->BackgroundColor;
    }
    /**
     * Set BackgroundColor value
     * @param string $backgroundColor
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setBackgroundColor($backgroundColor = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundColor) && !is_string($backgroundColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($backgroundColor)), __LINE__);
        }
        $this->BackgroundColor = $backgroundColor;
        return $this;
    }
    /**
     * Get BorderColor value
     * @return string|null
     */
    public function getBorderColor()
    {
        return $this->BorderColor;
    }
    /**
     * Set BorderColor value
     * @param string $borderColor
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setBorderColor($borderColor = null)
    {
        // validation for constraint: string
        if (!is_null($borderColor) && !is_string($borderColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($borderColor)), __LINE__);
        }
        $this->BorderColor = $borderColor;
        return $this;
    }
    /**
     * Get BorderWidth value
     * @return int|null
     */
    public function getBorderWidth()
    {
        return $this->BorderWidth;
    }
    /**
     * Set BorderWidth value
     * @param int $borderWidth
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setBorderWidth($borderWidth = null)
    {
        // validation for constraint: int
        if (!is_null($borderWidth) && !is_numeric($borderWidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($borderWidth)), __LINE__);
        }
        $this->BorderWidth = $borderWidth;
        return $this;
    }
    /**
     * Get Cellpadding value
     * @return int|null
     */
    public function getCellpadding()
    {
        return $this->Cellpadding;
    }
    /**
     * Set Cellpadding value
     * @param int $cellpadding
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setCellpadding($cellpadding = null)
    {
        // validation for constraint: int
        if (!is_null($cellpadding) && !is_numeric($cellpadding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cellpadding)), __LINE__);
        }
        $this->Cellpadding = $cellpadding;
        return $this;
    }
    /**
     * Get Cellspacing value
     * @return int|null
     */
    public function getCellspacing()
    {
        return $this->Cellspacing;
    }
    /**
     * Set Cellspacing value
     * @param int $cellspacing
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setCellspacing($cellspacing = null)
    {
        // validation for constraint: int
        if (!is_null($cellspacing) && !is_numeric($cellspacing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cellspacing)), __LINE__);
        }
        $this->Cellspacing = $cellspacing;
        return $this;
    }
    /**
     * Get Width value
     * @return string|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param string $width
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setWidth($width = null)
    {
        // validation for constraint: string
        if (!is_null($width) && !is_string($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get FontFamily value
     * @return string|null
     */
    public function getFontFamily()
    {
        return $this->FontFamily;
    }
    /**
     * Set FontFamily value
     * @param string $fontFamily
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setFontFamily($fontFamily = null)
    {
        // validation for constraint: string
        if (!is_null($fontFamily) && !is_string($fontFamily)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fontFamily)), __LINE__);
        }
        $this->FontFamily = $fontFamily;
        return $this;
    }
    /**
     * Get HasFontSize value
     * @return bool|null
     */
    public function getHasFontSize()
    {
        return $this->HasFontSize;
    }
    /**
     * Set HasFontSize value
     * @param bool $hasFontSize
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setHasFontSize($hasFontSize = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasFontSize) && !is_bool($hasFontSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasFontSize)), __LINE__);
        }
        $this->HasFontSize = $hasFontSize;
        return $this;
    }
    /**
     * Get IsLocked value
     * @return bool|null
     */
    public function getIsLocked()
    {
        return $this->IsLocked;
    }
    /**
     * Set IsLocked value
     * @param bool $isLocked
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public function setIsLocked($isLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLocked) && !is_bool($isLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isLocked)), __LINE__);
        }
        $this->IsLocked = $isLocked;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ContentArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
