<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactEventCreateResult StructType
 * @subpackage Structs
 */
class ContactEventCreateResult extends CreateResult
{
    /**
     * The EventInstanceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventInstanceID;
    /**
     * The AsyncRequestID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AsyncRequestID;
    /**
     * Constructor method for ContactEventCreateResult
     * @uses ContactEventCreateResult::setEventInstanceID()
     * @uses ContactEventCreateResult::setAsyncRequestID()
     * @param string $eventInstanceID
     * @param int $asyncRequestID
     */
    public function __construct($eventInstanceID = null, $asyncRequestID = null)
    {
        $this
            ->setEventInstanceID($eventInstanceID)
            ->setAsyncRequestID($asyncRequestID);
    }
    /**
     * Get EventInstanceID value
     * @return string|null
     */
    public function getEventInstanceID()
    {
        return $this->EventInstanceID;
    }
    /**
     * Set EventInstanceID value
     * @param string $eventInstanceID
     * @return \App\Library\ExactTarget\StructType\ContactEventCreateResult
     */
    public function setEventInstanceID($eventInstanceID = null)
    {
        // validation for constraint: string
        if (!is_null($eventInstanceID) && !is_string($eventInstanceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventInstanceID)), __LINE__);
        }
        $this->EventInstanceID = $eventInstanceID;
        return $this;
    }
    /**
     * Get AsyncRequestID value
     * @return int|null
     */
    public function getAsyncRequestID()
    {
        return $this->AsyncRequestID;
    }
    /**
     * Set AsyncRequestID value
     * @param int $asyncRequestID
     * @return \App\Library\ExactTarget\StructType\ContactEventCreateResult
     */
    public function setAsyncRequestID($asyncRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($asyncRequestID) && !is_numeric($asyncRequestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($asyncRequestID)), __LINE__);
        }
        $this->AsyncRequestID = $asyncRequestID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ContactEventCreateResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
