<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Configurations StructType
 * @subpackage Structs
 */
class Configurations extends AbstractStructBase
{
    /**
     * The Configuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject[]
     */
    public $Configuration;
    /**
     * Constructor method for Configurations
     * @uses Configurations::setConfiguration()
     * @param \App\Library\ExactTarget\StructType\APIObject[] $configuration
     */
    public function __construct(array $configuration = array())
    {
        $this
            ->setConfiguration($configuration);
    }
    /**
     * Get Configuration value
     * @return \App\Library\ExactTarget\StructType\APIObject[]|null
     */
    public function getConfiguration()
    {
        return $this->Configuration;
    }
    /**
     * Set Configuration value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject[] $configuration
     * @return \App\Library\ExactTarget\StructType\Configurations
     */
    public function setConfiguration(array $configuration = array())
    {
        foreach ($configuration as $configurationsConfigurationItem) {
            // validation for constraint: itemType
            if (!$configurationsConfigurationItem instanceof \App\Library\ExactTarget\StructType\APIObject) {
                throw new \InvalidArgumentException(sprintf('The Configuration property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($configurationsConfigurationItem) ? get_class($configurationsConfigurationItem) : gettype($configurationsConfigurationItem)), __LINE__);
            }
        }
        $this->Configuration = $configuration;
        return $this;
    }
    /**
     * Add item to Configuration value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject $item
     * @return \App\Library\ExactTarget\StructType\Configurations
     */
    public function addToConfiguration(\App\Library\ExactTarget\StructType\APIObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIObject) {
            throw new \InvalidArgumentException(sprintf('The Configuration property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Configuration[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Configurations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
