<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompressionConfiguration StructType
 * @subpackage Structs
 */
class CompressionConfiguration extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Encoding
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Encoding;
    /**
     * Constructor method for CompressionConfiguration
     * @uses CompressionConfiguration::setType()
     * @uses CompressionConfiguration::setEncoding()
     * @param string $type
     * @param string $encoding
     */
    public function __construct($type = null, $encoding = null)
    {
        $this
            ->setType($type)
            ->setEncoding($encoding);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \App\Library\ExactTarget\EnumType\CompressionType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\CompressionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \App\Library\ExactTarget\StructType\CompressionConfiguration
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\CompressionType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \App\Library\ExactTarget\EnumType\CompressionType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->Encoding;
    }
    /**
     * Set Encoding value
     * @uses \App\Library\ExactTarget\EnumType\CompressionEncoding::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\CompressionEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encoding
     * @return \App\Library\ExactTarget\StructType\CompressionConfiguration
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\CompressionEncoding::valueIsValid($encoding)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $encoding, implode(', ', \App\Library\ExactTarget\EnumType\CompressionEncoding::getValidValues())), __LINE__);
        }
        $this->Encoding = $encoding;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\CompressionConfiguration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
