<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessRule StructType
 * @subpackage Structs
 */
class BusinessRule extends APIObject
{
    /**
     * The MemberBusinessRuleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MemberBusinessRuleID;
    /**
     * The BusinessRuleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BusinessRuleID;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Data;
    /**
     * The Quality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Quality;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DisplayName;
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProductCode;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The IsViewable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsViewable;
    /**
     * The IsInheritedFromParent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsInheritedFromParent;
    /**
     * Constructor method for BusinessRule
     * @uses BusinessRule::setMemberBusinessRuleID()
     * @uses BusinessRule::setBusinessRuleID()
     * @uses BusinessRule::setData()
     * @uses BusinessRule::setQuality()
     * @uses BusinessRule::setName()
     * @uses BusinessRule::setDisplayName()
     * @uses BusinessRule::setProductCode()
     * @uses BusinessRule::setType()
     * @uses BusinessRule::setDescription()
     * @uses BusinessRule::setIsViewable()
     * @uses BusinessRule::setIsInheritedFromParent()
     * @param int $memberBusinessRuleID
     * @param int $businessRuleID
     * @param int $data
     * @param string $quality
     * @param string $name
     * @param string $displayName
     * @param string $productCode
     * @param string $type
     * @param string $description
     * @param bool $isViewable
     * @param bool $isInheritedFromParent
     */
    public function __construct($memberBusinessRuleID = null, $businessRuleID = null, $data = null, $quality = null, $name = null, $displayName = null, $productCode = null, $type = null, $description = null, $isViewable = null, $isInheritedFromParent = null)
    {
        $this
            ->setMemberBusinessRuleID($memberBusinessRuleID)
            ->setBusinessRuleID($businessRuleID)
            ->setData($data)
            ->setQuality($quality)
            ->setName($name)
            ->setDisplayName($displayName)
            ->setProductCode($productCode)
            ->setType($type)
            ->setDescription($description)
            ->setIsViewable($isViewable)
            ->setIsInheritedFromParent($isInheritedFromParent);
    }
    /**
     * Get MemberBusinessRuleID value
     * @return int
     */
    public function getMemberBusinessRuleID()
    {
        return $this->MemberBusinessRuleID;
    }
    /**
     * Set MemberBusinessRuleID value
     * @param int $memberBusinessRuleID
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setMemberBusinessRuleID($memberBusinessRuleID = null)
    {
        // validation for constraint: int
        if (!is_null($memberBusinessRuleID) && !is_numeric($memberBusinessRuleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($memberBusinessRuleID)), __LINE__);
        }
        $this->MemberBusinessRuleID = $memberBusinessRuleID;
        return $this;
    }
    /**
     * Get BusinessRuleID value
     * @return int
     */
    public function getBusinessRuleID()
    {
        return $this->BusinessRuleID;
    }
    /**
     * Set BusinessRuleID value
     * @param int $businessRuleID
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setBusinessRuleID($businessRuleID = null)
    {
        // validation for constraint: int
        if (!is_null($businessRuleID) && !is_numeric($businessRuleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($businessRuleID)), __LINE__);
        }
        $this->BusinessRuleID = $businessRuleID;
        return $this;
    }
    /**
     * Get Data value
     * @return int
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param int $data
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setData($data = null)
    {
        // validation for constraint: int
        if (!is_null($data) && !is_numeric($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Quality value
     * @return string
     */
    public function getQuality()
    {
        return $this->Quality;
    }
    /**
     * Set Quality value
     * @param string $quality
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setQuality($quality = null)
    {
        // validation for constraint: string
        if (!is_null($quality) && !is_string($quality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quality)), __LINE__);
        }
        $this->Quality = $quality;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get IsViewable value
     * @return bool|null
     */
    public function getIsViewable()
    {
        return $this->IsViewable;
    }
    /**
     * Set IsViewable value
     * @param bool $isViewable
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setIsViewable($isViewable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isViewable) && !is_bool($isViewable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isViewable)), __LINE__);
        }
        $this->IsViewable = $isViewable;
        return $this;
    }
    /**
     * Get IsInheritedFromParent value
     * @return bool|null
     */
    public function getIsInheritedFromParent()
    {
        return $this->IsInheritedFromParent;
    }
    /**
     * Set IsInheritedFromParent value
     * @param bool $isInheritedFromParent
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public function setIsInheritedFromParent($isInheritedFromParent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInheritedFromParent) && !is_bool($isInheritedFromParent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isInheritedFromParent)), __LINE__);
        }
        $this->IsInheritedFromParent = $isInheritedFromParent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\BusinessRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
