<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutomationTask StructType
 * @subpackage Structs
 */
class AutomationTask extends APIObject
{
    /**
     * The AutomationTaskType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutomationTaskType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Automation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Automation
     */
    public $Automation;
    /**
     * The Sequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sequence;
    /**
     * The Activities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Activities
     */
    public $Activities;
    /**
     * Constructor method for AutomationTask
     * @uses AutomationTask::setAutomationTaskType()
     * @uses AutomationTask::setName()
     * @uses AutomationTask::setDescription()
     * @uses AutomationTask::setAutomation()
     * @uses AutomationTask::setSequence()
     * @uses AutomationTask::setActivities()
     * @param string $automationTaskType
     * @param string $name
     * @param string $description
     * @param \App\Library\ExactTarget\StructType\Automation $automation
     * @param int $sequence
     * @param \App\Library\ExactTarget\StructType\Activities $activities
     */
    public function __construct($automationTaskType = null, $name = null, $description = null, \App\Library\ExactTarget\StructType\Automation $automation = null, $sequence = null, \App\Library\ExactTarget\StructType\Activities $activities = null)
    {
        $this
            ->setAutomationTaskType($automationTaskType)
            ->setName($name)
            ->setDescription($description)
            ->setAutomation($automation)
            ->setSequence($sequence)
            ->setActivities($activities);
    }
    /**
     * Get AutomationTaskType value
     * @return string|null
     */
    public function getAutomationTaskType()
    {
        return $this->AutomationTaskType;
    }
    /**
     * Set AutomationTaskType value
     * @param string $automationTaskType
     * @return \App\Library\ExactTarget\StructType\AutomationTask
     */
    public function setAutomationTaskType($automationTaskType = null)
    {
        // validation for constraint: string
        if (!is_null($automationTaskType) && !is_string($automationTaskType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automationTaskType)), __LINE__);
        }
        $this->AutomationTaskType = $automationTaskType;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\AutomationTask
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\AutomationTask
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Automation value
     * @return \App\Library\ExactTarget\StructType\Automation|null
     */
    public function getAutomation()
    {
        return $this->Automation;
    }
    /**
     * Set Automation value
     * @param \App\Library\ExactTarget\StructType\Automation $automation
     * @return \App\Library\ExactTarget\StructType\AutomationTask
     */
    public function setAutomation(\App\Library\ExactTarget\StructType\Automation $automation = null)
    {
        $this->Automation = $automation;
        return $this;
    }
    /**
     * Get Sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->Sequence;
    }
    /**
     * Set Sequence value
     * @param int $sequence
     * @return \App\Library\ExactTarget\StructType\AutomationTask
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->Sequence = $sequence;
        return $this;
    }
    /**
     * Get Activities value
     * @return \App\Library\ExactTarget\StructType\Activities|null
     */
    public function getActivities()
    {
        return $this->Activities;
    }
    /**
     * Set Activities value
     * @param \App\Library\ExactTarget\StructType\Activities $activities
     * @return \App\Library\ExactTarget\StructType\AutomationTask
     */
    public function setActivities(\App\Library\ExactTarget\StructType\Activities $activities = null)
    {
        $this->Activities = $activities;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AutomationTask
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
