<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutomationNotification StructType
 * @subpackage Structs
 */
class AutomationNotification extends APIObject
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Address;
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Body;
    /**
     * The ChannelType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChannelType;
    /**
     * The NotificationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationType;
    /**
     * The AutomationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutomationID;
    /**
     * Constructor method for AutomationNotification
     * @uses AutomationNotification::setAddress()
     * @uses AutomationNotification::setBody()
     * @uses AutomationNotification::setChannelType()
     * @uses AutomationNotification::setNotificationType()
     * @uses AutomationNotification::setAutomationID()
     * @param string $address
     * @param string $body
     * @param string $channelType
     * @param string $notificationType
     * @param string $automationID
     */
    public function __construct($address = null, $body = null, $channelType = null, $notificationType = null, $automationID = null)
    {
        $this
            ->setAddress($address)
            ->setBody($body)
            ->setChannelType($channelType)
            ->setNotificationType($notificationType)
            ->setAutomationID($automationID);
    }
    /**
     * Get Address value
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \App\Library\ExactTarget\StructType\AutomationNotification
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Body value
     * @return string|null
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param string $body
     * @return \App\Library\ExactTarget\StructType\AutomationNotification
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($body)), __LINE__);
        }
        $this->Body = $body;
        return $this;
    }
    /**
     * Get ChannelType value
     * @return string|null
     */
    public function getChannelType()
    {
        return $this->ChannelType;
    }
    /**
     * Set ChannelType value
     * @param string $channelType
     * @return \App\Library\ExactTarget\StructType\AutomationNotification
     */
    public function setChannelType($channelType = null)
    {
        // validation for constraint: string
        if (!is_null($channelType) && !is_string($channelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($channelType)), __LINE__);
        }
        $this->ChannelType = $channelType;
        return $this;
    }
    /**
     * Get NotificationType value
     * @return string|null
     */
    public function getNotificationType()
    {
        return $this->NotificationType;
    }
    /**
     * Set NotificationType value
     * @param string $notificationType
     * @return \App\Library\ExactTarget\StructType\AutomationNotification
     */
    public function setNotificationType($notificationType = null)
    {
        // validation for constraint: string
        if (!is_null($notificationType) && !is_string($notificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationType)), __LINE__);
        }
        $this->NotificationType = $notificationType;
        return $this;
    }
    /**
     * Get AutomationID value
     * @return string|null
     */
    public function getAutomationID()
    {
        return $this->AutomationID;
    }
    /**
     * Set AutomationID value
     * @param string $automationID
     * @return \App\Library\ExactTarget\StructType\AutomationNotification
     */
    public function setAutomationID($automationID = null)
    {
        // validation for constraint: string
        if (!is_null($automationID) && !is_string($automationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automationID)), __LINE__);
        }
        $this->AutomationID = $automationID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AutomationNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
