<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutomationInstance StructType
 * @subpackage Structs
 */
class AutomationInstance extends Automation
{
    /**
     * The AutomationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutomationID;
    /**
     * The StatusMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessage;
    /**
     * The StatusLastUpdate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusLastUpdate;
    /**
     * The TaskInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TaskInstances
     */
    public $TaskInstances;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartTime;
    /**
     * The CompletedTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompletedTime;
    /**
     * Constructor method for AutomationInstance
     * @uses AutomationInstance::setAutomationID()
     * @uses AutomationInstance::setStatusMessage()
     * @uses AutomationInstance::setStatusLastUpdate()
     * @uses AutomationInstance::setTaskInstances()
     * @uses AutomationInstance::setStartTime()
     * @uses AutomationInstance::setCompletedTime()
     * @param string $automationID
     * @param string $statusMessage
     * @param string $statusLastUpdate
     * @param \App\Library\ExactTarget\StructType\TaskInstances $taskInstances
     * @param string $startTime
     * @param string $completedTime
     */
    public function __construct($automationID = null, $statusMessage = null, $statusLastUpdate = null, \App\Library\ExactTarget\StructType\TaskInstances $taskInstances = null, $startTime = null, $completedTime = null)
    {
        $this
            ->setAutomationID($automationID)
            ->setStatusMessage($statusMessage)
            ->setStatusLastUpdate($statusLastUpdate)
            ->setTaskInstances($taskInstances)
            ->setStartTime($startTime)
            ->setCompletedTime($completedTime);
    }
    /**
     * Get AutomationID value
     * @return string|null
     */
    public function getAutomationID()
    {
        return $this->AutomationID;
    }
    /**
     * Set AutomationID value
     * @param string $automationID
     * @return \App\Library\ExactTarget\StructType\AutomationInstance
     */
    public function setAutomationID($automationID = null)
    {
        // validation for constraint: string
        if (!is_null($automationID) && !is_string($automationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automationID)), __LINE__);
        }
        $this->AutomationID = $automationID;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \App\Library\ExactTarget\StructType\AutomationInstance
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get StatusLastUpdate value
     * @return string|null
     */
    public function getStatusLastUpdate()
    {
        return $this->StatusLastUpdate;
    }
    /**
     * Set StatusLastUpdate value
     * @param string $statusLastUpdate
     * @return \App\Library\ExactTarget\StructType\AutomationInstance
     */
    public function setStatusLastUpdate($statusLastUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($statusLastUpdate) && !is_string($statusLastUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusLastUpdate)), __LINE__);
        }
        $this->StatusLastUpdate = $statusLastUpdate;
        return $this;
    }
    /**
     * Get TaskInstances value
     * @return \App\Library\ExactTarget\StructType\TaskInstances|null
     */
    public function getTaskInstances()
    {
        return $this->TaskInstances;
    }
    /**
     * Set TaskInstances value
     * @param \App\Library\ExactTarget\StructType\TaskInstances $taskInstances
     * @return \App\Library\ExactTarget\StructType\AutomationInstance
     */
    public function setTaskInstances(\App\Library\ExactTarget\StructType\TaskInstances $taskInstances = null)
    {
        $this->TaskInstances = $taskInstances;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \App\Library\ExactTarget\StructType\AutomationInstance
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get CompletedTime value
     * @return string|null
     */
    public function getCompletedTime()
    {
        return $this->CompletedTime;
    }
    /**
     * Set CompletedTime value
     * @param string $completedTime
     * @return \App\Library\ExactTarget\StructType\AutomationInstance
     */
    public function setCompletedTime($completedTime = null)
    {
        // validation for constraint: string
        if (!is_null($completedTime) && !is_string($completedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($completedTime)), __LINE__);
        }
        $this->CompletedTime = $completedTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AutomationInstance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
