<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutomationChain StructType
 * @subpackage Structs
 */
class AutomationChain extends InteractionDefinition
{
    /**
     * The AutomationToChainID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutomationToChainID;
    /**
     * Constructor method for AutomationChain
     * @uses AutomationChain::setAutomationToChainID()
     * @param string $automationToChainID
     */
    public function __construct($automationToChainID = null)
    {
        $this
            ->setAutomationToChainID($automationToChainID);
    }
    /**
     * Get AutomationToChainID value
     * @return string|null
     */
    public function getAutomationToChainID()
    {
        return $this->AutomationToChainID;
    }
    /**
     * Set AutomationToChainID value
     * @param string $automationToChainID
     * @return \App\Library\ExactTarget\StructType\AutomationChain
     */
    public function setAutomationToChainID($automationToChainID = null)
    {
        // validation for constraint: string
        if (!is_null($automationToChainID) && !is_string($automationToChainID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automationToChainID)), __LINE__);
        }
        $this->AutomationToChainID = $automationToChainID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AutomationChain
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
