<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutomationActivityInstance StructType
 * @subpackage Structs
 */
class AutomationActivityInstance extends AutomationActivity
{
    /**
     * The ActivityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityID;
    /**
     * The AutomationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutomationID;
    /**
     * The SequenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SequenceID;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Status;
    /**
     * The StatusLastUpdate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusLastUpdate;
    /**
     * The StatusMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessage;
    /**
     * The ActivityDefinition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public $ActivityDefinition;
    /**
     * The AutomationInstance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationInstance
     */
    public $AutomationInstance;
    /**
     * The AutomationTaskInstance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationTaskInstance
     */
    public $AutomationTaskInstance;
    /**
     * The ScheduledTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledTime;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartTime;
    /**
     * The CompletedTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompletedTime;
    /**
     * Constructor method for AutomationActivityInstance
     * @uses AutomationActivityInstance::setActivityID()
     * @uses AutomationActivityInstance::setAutomationID()
     * @uses AutomationActivityInstance::setSequenceID()
     * @uses AutomationActivityInstance::setStatus()
     * @uses AutomationActivityInstance::setStatusLastUpdate()
     * @uses AutomationActivityInstance::setStatusMessage()
     * @uses AutomationActivityInstance::setActivityDefinition()
     * @uses AutomationActivityInstance::setAutomationInstance()
     * @uses AutomationActivityInstance::setAutomationTaskInstance()
     * @uses AutomationActivityInstance::setScheduledTime()
     * @uses AutomationActivityInstance::setStartTime()
     * @uses AutomationActivityInstance::setCompletedTime()
     * @param string $activityID
     * @param string $automationID
     * @param int $sequenceID
     * @param int $status
     * @param string $statusLastUpdate
     * @param string $statusMessage
     * @param \App\Library\ExactTarget\StructType\AutomationActivity $activityDefinition
     * @param \App\Library\ExactTarget\StructType\AutomationInstance $automationInstance
     * @param \App\Library\ExactTarget\StructType\AutomationTaskInstance $automationTaskInstance
     * @param string $scheduledTime
     * @param string $startTime
     * @param string $completedTime
     */
    public function __construct($activityID = null, $automationID = null, $sequenceID = null, $status = null, $statusLastUpdate = null, $statusMessage = null, \App\Library\ExactTarget\StructType\AutomationActivity $activityDefinition = null, \App\Library\ExactTarget\StructType\AutomationInstance $automationInstance = null, \App\Library\ExactTarget\StructType\AutomationTaskInstance $automationTaskInstance = null, $scheduledTime = null, $startTime = null, $completedTime = null)
    {
        $this
            ->setActivityID($activityID)
            ->setAutomationID($automationID)
            ->setSequenceID($sequenceID)
            ->setStatus($status)
            ->setStatusLastUpdate($statusLastUpdate)
            ->setStatusMessage($statusMessage)
            ->setActivityDefinition($activityDefinition)
            ->setAutomationInstance($automationInstance)
            ->setAutomationTaskInstance($automationTaskInstance)
            ->setScheduledTime($scheduledTime)
            ->setStartTime($startTime)
            ->setCompletedTime($completedTime);
    }
    /**
     * Get ActivityID value
     * @return string|null
     */
    public function getActivityID()
    {
        return $this->ActivityID;
    }
    /**
     * Set ActivityID value
     * @param string $activityID
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setActivityID($activityID = null)
    {
        // validation for constraint: string
        if (!is_null($activityID) && !is_string($activityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityID)), __LINE__);
        }
        $this->ActivityID = $activityID;
        return $this;
    }
    /**
     * Get AutomationID value
     * @return string|null
     */
    public function getAutomationID()
    {
        return $this->AutomationID;
    }
    /**
     * Set AutomationID value
     * @param string $automationID
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setAutomationID($automationID = null)
    {
        // validation for constraint: string
        if (!is_null($automationID) && !is_string($automationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automationID)), __LINE__);
        }
        $this->AutomationID = $automationID;
        return $this;
    }
    /**
     * Get SequenceID value
     * @return int|null
     */
    public function getSequenceID()
    {
        return $this->SequenceID;
    }
    /**
     * Set SequenceID value
     * @param int $sequenceID
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setSequenceID($sequenceID = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceID) && !is_numeric($sequenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceID)), __LINE__);
        }
        $this->SequenceID = $sequenceID;
        return $this;
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusLastUpdate value
     * @return string|null
     */
    public function getStatusLastUpdate()
    {
        return $this->StatusLastUpdate;
    }
    /**
     * Set StatusLastUpdate value
     * @param string $statusLastUpdate
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setStatusLastUpdate($statusLastUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($statusLastUpdate) && !is_string($statusLastUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusLastUpdate)), __LINE__);
        }
        $this->StatusLastUpdate = $statusLastUpdate;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get ActivityDefinition value
     * @return \App\Library\ExactTarget\StructType\AutomationActivity|null
     */
    public function getActivityDefinition()
    {
        return $this->ActivityDefinition;
    }
    /**
     * Set ActivityDefinition value
     * @param \App\Library\ExactTarget\StructType\AutomationActivity $activityDefinition
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setActivityDefinition(\App\Library\ExactTarget\StructType\AutomationActivity $activityDefinition = null)
    {
        $this->ActivityDefinition = $activityDefinition;
        return $this;
    }
    /**
     * Get AutomationInstance value
     * @return \App\Library\ExactTarget\StructType\AutomationInstance|null
     */
    public function getAutomationInstance()
    {
        return $this->AutomationInstance;
    }
    /**
     * Set AutomationInstance value
     * @param \App\Library\ExactTarget\StructType\AutomationInstance $automationInstance
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setAutomationInstance(\App\Library\ExactTarget\StructType\AutomationInstance $automationInstance = null)
    {
        $this->AutomationInstance = $automationInstance;
        return $this;
    }
    /**
     * Get AutomationTaskInstance value
     * @return \App\Library\ExactTarget\StructType\AutomationTaskInstance|null
     */
    public function getAutomationTaskInstance()
    {
        return $this->AutomationTaskInstance;
    }
    /**
     * Set AutomationTaskInstance value
     * @param \App\Library\ExactTarget\StructType\AutomationTaskInstance $automationTaskInstance
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setAutomationTaskInstance(\App\Library\ExactTarget\StructType\AutomationTaskInstance $automationTaskInstance = null)
    {
        $this->AutomationTaskInstance = $automationTaskInstance;
        return $this;
    }
    /**
     * Get ScheduledTime value
     * @return string|null
     */
    public function getScheduledTime()
    {
        return $this->ScheduledTime;
    }
    /**
     * Set ScheduledTime value
     * @param string $scheduledTime
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setScheduledTime($scheduledTime = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledTime) && !is_string($scheduledTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledTime)), __LINE__);
        }
        $this->ScheduledTime = $scheduledTime;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get CompletedTime value
     * @return string|null
     */
    public function getCompletedTime()
    {
        return $this->CompletedTime;
    }
    /**
     * Set CompletedTime value
     * @param string $completedTime
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public function setCompletedTime($completedTime = null)
    {
        // validation for constraint: string
        if (!is_null($completedTime) && !is_string($completedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($completedTime)), __LINE__);
        }
        $this->CompletedTime = $completedTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
