<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AsyncResponse StructType
 * @subpackage Structs
 */
class AsyncResponse extends AbstractStructBase
{
    /**
     * The ResponseType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResponseType;
    /**
     * The ResponseAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResponseAddress;
    /**
     * The RespondWhen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RespondWhen;
    /**
     * The IncludeResults
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeResults;
    /**
     * The IncludeObjects
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeObjects;
    /**
     * The OnlyIncludeBase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnlyIncludeBase;
    /**
     * Constructor method for AsyncResponse
     * @uses AsyncResponse::setResponseType()
     * @uses AsyncResponse::setResponseAddress()
     * @uses AsyncResponse::setRespondWhen()
     * @uses AsyncResponse::setIncludeResults()
     * @uses AsyncResponse::setIncludeObjects()
     * @uses AsyncResponse::setOnlyIncludeBase()
     * @param string $responseType
     * @param string $responseAddress
     * @param string $respondWhen
     * @param bool $includeResults
     * @param bool $includeObjects
     * @param bool $onlyIncludeBase
     */
    public function __construct($responseType = null, $responseAddress = null, $respondWhen = null, $includeResults = null, $includeObjects = null, $onlyIncludeBase = null)
    {
        $this
            ->setResponseType($responseType)
            ->setResponseAddress($responseAddress)
            ->setRespondWhen($respondWhen)
            ->setIncludeResults($includeResults)
            ->setIncludeObjects($includeObjects)
            ->setOnlyIncludeBase($onlyIncludeBase);
    }
    /**
     * Get ResponseType value
     * @return string
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @uses \App\Library\ExactTarget\EnumType\AsyncResponseType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\AsyncResponseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $responseType
     * @return \App\Library\ExactTarget\StructType\AsyncResponse
     */
    public function setResponseType($responseType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\AsyncResponseType::valueIsValid($responseType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $responseType, implode(', ', \App\Library\ExactTarget\EnumType\AsyncResponseType::getValidValues())), __LINE__);
        }
        $this->ResponseType = $responseType;
        return $this;
    }
    /**
     * Get ResponseAddress value
     * @return string
     */
    public function getResponseAddress()
    {
        return $this->ResponseAddress;
    }
    /**
     * Set ResponseAddress value
     * @param string $responseAddress
     * @return \App\Library\ExactTarget\StructType\AsyncResponse
     */
    public function setResponseAddress($responseAddress = null)
    {
        // validation for constraint: string
        if (!is_null($responseAddress) && !is_string($responseAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseAddress)), __LINE__);
        }
        $this->ResponseAddress = $responseAddress;
        return $this;
    }
    /**
     * Get RespondWhen value
     * @return string|null
     */
    public function getRespondWhen()
    {
        return $this->RespondWhen;
    }
    /**
     * Set RespondWhen value
     * @uses \App\Library\ExactTarget\EnumType\RespondWhen::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\RespondWhen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $respondWhen
     * @return \App\Library\ExactTarget\StructType\AsyncResponse
     */
    public function setRespondWhen($respondWhen = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\RespondWhen::valueIsValid($respondWhen)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $respondWhen, implode(', ', \App\Library\ExactTarget\EnumType\RespondWhen::getValidValues())), __LINE__);
        }
        $this->RespondWhen = $respondWhen;
        return $this;
    }
    /**
     * Get IncludeResults value
     * @return bool|null
     */
    public function getIncludeResults()
    {
        return $this->IncludeResults;
    }
    /**
     * Set IncludeResults value
     * @param bool $includeResults
     * @return \App\Library\ExactTarget\StructType\AsyncResponse
     */
    public function setIncludeResults($includeResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeResults) && !is_bool($includeResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeResults)), __LINE__);
        }
        $this->IncludeResults = $includeResults;
        return $this;
    }
    /**
     * Get IncludeObjects value
     * @return bool|null
     */
    public function getIncludeObjects()
    {
        return $this->IncludeObjects;
    }
    /**
     * Set IncludeObjects value
     * @param bool $includeObjects
     * @return \App\Library\ExactTarget\StructType\AsyncResponse
     */
    public function setIncludeObjects($includeObjects = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeObjects) && !is_bool($includeObjects)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeObjects)), __LINE__);
        }
        $this->IncludeObjects = $includeObjects;
        return $this;
    }
    /**
     * Get OnlyIncludeBase value
     * @return bool|null
     */
    public function getOnlyIncludeBase()
    {
        return $this->OnlyIncludeBase;
    }
    /**
     * Set OnlyIncludeBase value
     * @param bool $onlyIncludeBase
     * @return \App\Library\ExactTarget\StructType\AsyncResponse
     */
    public function setOnlyIncludeBase($onlyIncludeBase = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyIncludeBase) && !is_bool($onlyIncludeBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onlyIncludeBase)), __LINE__);
        }
        $this->OnlyIncludeBase = $onlyIncludeBase;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AsyncResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
