<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AsyncRequestResult StructType
 * @subpackage Structs
 */
class AsyncRequestResult extends APIObject
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The CompleteDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompleteDate;
    /**
     * The CallStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CallStatus;
    /**
     * The CallMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CallMessage;
    /**
     * Constructor method for AsyncRequestResult
     * @uses AsyncRequestResult::setStatus()
     * @uses AsyncRequestResult::setCompleteDate()
     * @uses AsyncRequestResult::setCallStatus()
     * @uses AsyncRequestResult::setCallMessage()
     * @param string $status
     * @param string $completeDate
     * @param string $callStatus
     * @param string $callMessage
     */
    public function __construct($status = null, $completeDate = null, $callStatus = null, $callMessage = null)
    {
        $this
            ->setStatus($status)
            ->setCompleteDate($completeDate)
            ->setCallStatus($callStatus)
            ->setCallMessage($callMessage);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\AsyncRequestResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CompleteDate value
     * @return string|null
     */
    public function getCompleteDate()
    {
        return $this->CompleteDate;
    }
    /**
     * Set CompleteDate value
     * @param string $completeDate
     * @return \App\Library\ExactTarget\StructType\AsyncRequestResult
     */
    public function setCompleteDate($completeDate = null)
    {
        // validation for constraint: string
        if (!is_null($completeDate) && !is_string($completeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($completeDate)), __LINE__);
        }
        $this->CompleteDate = $completeDate;
        return $this;
    }
    /**
     * Get CallStatus value
     * @return string|null
     */
    public function getCallStatus()
    {
        return $this->CallStatus;
    }
    /**
     * Set CallStatus value
     * @param string $callStatus
     * @return \App\Library\ExactTarget\StructType\AsyncRequestResult
     */
    public function setCallStatus($callStatus = null)
    {
        // validation for constraint: string
        if (!is_null($callStatus) && !is_string($callStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callStatus)), __LINE__);
        }
        $this->CallStatus = $callStatus;
        return $this;
    }
    /**
     * Get CallMessage value
     * @return string|null
     */
    public function getCallMessage()
    {
        return $this->CallMessage;
    }
    /**
     * Set CallMessage value
     * @param string $callMessage
     * @return \App\Library\ExactTarget\StructType\AsyncRequestResult
     */
    public function setCallMessage($callMessage = null)
    {
        // validation for constraint: string
        if (!is_null($callMessage) && !is_string($callMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callMessage)), __LINE__);
        }
        $this->CallMessage = $callMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AsyncRequestResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
